/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.arrow.util.Preconditions;

public class JdbcFieldInfo {
    private final int column;
    private final int jdbcType;
    private final int nullability;
    private final int precision;
    private final int scale;
    private final String typeName;
    private final int displaySize;

    public JdbcFieldInfo(int jdbcType) {
        Preconditions.checkArgument((jdbcType != 3 && jdbcType != 2 ? 1 : 0) != 0, (Object)"DECIMAL and NUMERIC types require a precision and scale; please use another constructor.");
        this.column = 0;
        this.jdbcType = jdbcType;
        this.nullability = 2;
        this.precision = 0;
        this.scale = 0;
        this.typeName = "";
        this.displaySize = 0;
    }

    public JdbcFieldInfo(int jdbcType, int precision, int scale) {
        this.column = 0;
        this.jdbcType = jdbcType;
        this.nullability = 2;
        this.precision = precision;
        this.scale = scale;
        this.typeName = "";
        this.displaySize = 0;
    }

    public JdbcFieldInfo(int jdbcType, int nullability, int precision, int scale) {
        this.column = 0;
        this.jdbcType = jdbcType;
        this.nullability = nullability;
        this.precision = precision;
        this.scale = scale;
        this.typeName = "";
        this.displaySize = 0;
    }

    public JdbcFieldInfo(ResultSetMetaData rsmd, int column) throws SQLException {
        Preconditions.checkNotNull((Object)rsmd, (Object)"ResultSetMetaData cannot be null.");
        Preconditions.checkArgument((column > 0 ? 1 : 0) != 0, (Object)"ResultSetMetaData columns have indices starting at 1.");
        Preconditions.checkArgument((column <= rsmd.getColumnCount() ? 1 : 0) != 0, (String)"The index must be within the number of columns (1 to %s, inclusive)", (int)rsmd.getColumnCount());
        this.column = column;
        this.jdbcType = rsmd.getColumnType(column);
        this.nullability = rsmd.isNullable(column);
        this.precision = rsmd.getPrecision(column);
        this.scale = rsmd.getScale(column);
        this.typeName = rsmd.getColumnTypeName(column);
        this.displaySize = rsmd.getColumnDisplaySize(column);
    }

    public JdbcFieldInfo(ResultSet rs) throws SQLException {
        this.column = rs.getInt("ORDINAL_POSITION");
        this.jdbcType = rs.getInt("DATA_TYPE");
        this.nullability = rs.getInt("NULLABLE");
        this.precision = rs.getInt("COLUMN_SIZE");
        this.scale = rs.getInt("DECIMAL_DIGITS");
        this.typeName = rs.getString("TYPE_NAME");
        this.displaySize = rs.getInt("CHAR_OCTET_LENGTH");
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public int isNullable() {
        return this.nullability;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int getColumn() {
        return this.column;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }
}

