/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.io.IOException;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.BinaryConsumer;
import org.apache.arrow.vector.VarBinaryVector;

public class BlobConsumer
extends BaseConsumer<VarBinaryVector> {
    private BinaryConsumer delegate;
    private final boolean nullable;

    public static BlobConsumer createConsumer(BinaryConsumer delegate, int index, boolean nullable) {
        return new BlobConsumer(delegate, index, nullable);
    }

    public BlobConsumer(BinaryConsumer delegate, int index, boolean nullable) {
        super(null, index);
        this.delegate = delegate;
        this.nullable = nullable;
    }

    @Override
    public void consume(ResultSet resultSet) throws SQLException, IOException {
        Blob blob = resultSet.getBlob(this.columnIndexInResultSet);
        if (blob != null) {
            this.delegate.consume(blob.getBinaryStream());
        }
        this.delegate.moveWriterPosition();
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    @Override
    public void resetValueVector(VarBinaryVector vector) {
        this.delegate = BinaryConsumer.createConsumer(vector, this.columnIndexInResultSet, this.nullable);
    }
}

