/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.binder;

import java.time.ZoneId;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.arrow.adapter.jdbc.binder.BigIntBinder;
import org.apache.arrow.adapter.jdbc.binder.BitBinder;
import org.apache.arrow.adapter.jdbc.binder.ColumnBinder;
import org.apache.arrow.adapter.jdbc.binder.DateDayBinder;
import org.apache.arrow.adapter.jdbc.binder.DateMilliBinder;
import org.apache.arrow.adapter.jdbc.binder.Decimal128Binder;
import org.apache.arrow.adapter.jdbc.binder.Decimal256Binder;
import org.apache.arrow.adapter.jdbc.binder.FixedSizeBinaryBinder;
import org.apache.arrow.adapter.jdbc.binder.Float4Binder;
import org.apache.arrow.adapter.jdbc.binder.Float8Binder;
import org.apache.arrow.adapter.jdbc.binder.IntBinder;
import org.apache.arrow.adapter.jdbc.binder.ListBinder;
import org.apache.arrow.adapter.jdbc.binder.MapBinder;
import org.apache.arrow.adapter.jdbc.binder.SmallIntBinder;
import org.apache.arrow.adapter.jdbc.binder.Time32Binder;
import org.apache.arrow.adapter.jdbc.binder.Time64Binder;
import org.apache.arrow.adapter.jdbc.binder.TimeStampBinder;
import org.apache.arrow.adapter.jdbc.binder.TinyIntBinder;
import org.apache.arrow.adapter.jdbc.binder.VarBinaryBinder;
import org.apache.arrow.adapter.jdbc.binder.VarCharBinder;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class ColumnBinderArrowTypeVisitor
implements ArrowType.ArrowTypeVisitor<ColumnBinder> {
    private final FieldVector vector;
    private final Integer jdbcType;

    public ColumnBinderArrowTypeVisitor(FieldVector vector, Integer jdbcType) {
        this.vector = vector;
        this.jdbcType = jdbcType;
    }

    public ColumnBinder visit(ArrowType.Null type) {
        throw new UnsupportedOperationException("No column binder implemented for type " + type);
    }

    public ColumnBinder visit(ArrowType.Struct type) {
        throw new UnsupportedOperationException("No column binder implemented for type " + type);
    }

    public ColumnBinder visit(ArrowType.List type) {
        return new ListBinder((ListVector)this.vector);
    }

    public ColumnBinder visit(ArrowType.LargeList type) {
        throw new UnsupportedOperationException("No column binder implemented for type " + type);
    }

    public ColumnBinder visit(ArrowType.FixedSizeList type) {
        throw new UnsupportedOperationException("No column binder implemented for type " + type);
    }

    public ColumnBinder visit(ArrowType.Union type) {
        throw new UnsupportedOperationException("No column binder implemented for type " + type);
    }

    public ColumnBinder visit(ArrowType.Map type) {
        return new MapBinder((MapVector)this.vector);
    }

    public ColumnBinder visit(ArrowType.Int type) {
        if (!type.getIsSigned()) {
            throw new UnsupportedOperationException("No column binder implemented for unsigned type " + type);
        }
        switch (type.getBitWidth()) {
            case 8: {
                return this.jdbcType == null ? new TinyIntBinder((TinyIntVector)this.vector) : new TinyIntBinder((TinyIntVector)this.vector, (int)this.jdbcType);
            }
            case 16: {
                return this.jdbcType == null ? new SmallIntBinder((SmallIntVector)this.vector) : new SmallIntBinder((SmallIntVector)this.vector, (int)this.jdbcType);
            }
            case 32: {
                return this.jdbcType == null ? new IntBinder((IntVector)this.vector) : new IntBinder((IntVector)this.vector, (int)this.jdbcType);
            }
            case 64: {
                return this.jdbcType == null ? new BigIntBinder((BigIntVector)this.vector) : new BigIntBinder((BigIntVector)this.vector, (int)this.jdbcType);
            }
        }
        throw new UnsupportedOperationException("No column binder implemented for type " + type);
    }

    public ColumnBinder visit(ArrowType.FloatingPoint type) {
        switch (type.getPrecision()) {
            case SINGLE: {
                return this.jdbcType == null ? new Float4Binder((Float4Vector)this.vector) : new Float4Binder((Float4Vector)this.vector, (int)this.jdbcType);
            }
            case DOUBLE: {
                return this.jdbcType == null ? new Float8Binder((Float8Vector)this.vector) : new Float8Binder((Float8Vector)this.vector, (int)this.jdbcType);
            }
        }
        throw new UnsupportedOperationException("No column binder implemented for type " + type);
    }

    public ColumnBinder visit(ArrowType.Utf8 type) {
        VarCharVector varChar = (VarCharVector)this.vector;
        return this.jdbcType == null ? new VarCharBinder<VarCharVector>(varChar, 12) : new VarCharBinder<VarCharVector>(varChar, (int)this.jdbcType);
    }

    public ColumnBinder visit(ArrowType.LargeUtf8 type) {
        LargeVarCharVector varChar = (LargeVarCharVector)this.vector;
        return this.jdbcType == null ? new VarCharBinder<LargeVarCharVector>(varChar, -1) : new VarCharBinder<LargeVarCharVector>(varChar, (int)this.jdbcType);
    }

    public ColumnBinder visit(ArrowType.Binary type) {
        VarBinaryVector varBinary = (VarBinaryVector)this.vector;
        return this.jdbcType == null ? new VarBinaryBinder<VarBinaryVector>(varBinary, -3) : new VarBinaryBinder<VarBinaryVector>(varBinary, (int)this.jdbcType);
    }

    public ColumnBinder visit(ArrowType.LargeBinary type) {
        LargeVarBinaryVector varBinary = (LargeVarBinaryVector)this.vector;
        return this.jdbcType == null ? new VarBinaryBinder<LargeVarBinaryVector>(varBinary, -4) : new VarBinaryBinder<LargeVarBinaryVector>(varBinary, (int)this.jdbcType);
    }

    public ColumnBinder visit(ArrowType.FixedSizeBinary type) {
        FixedSizeBinaryVector binary = (FixedSizeBinaryVector)this.vector;
        return this.jdbcType == null ? new FixedSizeBinaryBinder(binary, -2) : new FixedSizeBinaryBinder(binary, (int)this.jdbcType);
    }

    public ColumnBinder visit(ArrowType.Bool type) {
        return this.jdbcType == null ? new BitBinder((BitVector)this.vector) : new BitBinder((BitVector)this.vector, (int)this.jdbcType);
    }

    public ColumnBinder visit(ArrowType.Decimal type) {
        if (type.getBitWidth() == 128) {
            DecimalVector decimalVector = (DecimalVector)this.vector;
            return this.jdbcType == null ? new Decimal128Binder(decimalVector) : new Decimal128Binder(decimalVector, (int)this.jdbcType);
        }
        if (type.getBitWidth() == 256) {
            Decimal256Vector decimalVector = (Decimal256Vector)this.vector;
            return this.jdbcType == null ? new Decimal256Binder(decimalVector) : new Decimal256Binder(decimalVector, (int)this.jdbcType);
        }
        throw new UnsupportedOperationException("No column binder implemented for type " + type);
    }

    public ColumnBinder visit(ArrowType.Date type) {
        switch (type.getUnit()) {
            case DAY: {
                return this.jdbcType == null ? new DateDayBinder((DateDayVector)this.vector) : new DateDayBinder((DateDayVector)this.vector, null, this.jdbcType);
            }
            case MILLISECOND: {
                return this.jdbcType == null ? new DateMilliBinder((DateMilliVector)this.vector) : new DateMilliBinder((DateMilliVector)this.vector, null, this.jdbcType);
            }
        }
        throw new UnsupportedOperationException("No column binder implemented for type " + type);
    }

    public ColumnBinder visit(ArrowType.Time type) {
        switch (type.getUnit()) {
            case SECOND: {
                return this.jdbcType == null ? new Time32Binder((TimeSecVector)this.vector) : new Time32Binder((TimeSecVector)this.vector, (int)this.jdbcType);
            }
            case MILLISECOND: {
                return this.jdbcType == null ? new Time32Binder((TimeMilliVector)this.vector) : new Time32Binder((TimeMilliVector)this.vector, (int)this.jdbcType);
            }
            case MICROSECOND: {
                return this.jdbcType == null ? new Time64Binder((TimeMicroVector)this.vector) : new Time64Binder((TimeMicroVector)this.vector, (int)this.jdbcType);
            }
            case NANOSECOND: {
                return this.jdbcType == null ? new Time64Binder((TimeNanoVector)this.vector) : new Time64Binder((TimeNanoVector)this.vector, (int)this.jdbcType);
            }
        }
        throw new UnsupportedOperationException("No column binder implemented for type " + type);
    }

    public ColumnBinder visit(ArrowType.Timestamp type) {
        Calendar calendar = null;
        String timezone = type.getTimezone();
        if (timezone != null && !timezone.isEmpty()) {
            calendar = Calendar.getInstance(TimeZone.getTimeZone(ZoneId.of(timezone)));
        }
        return new TimeStampBinder((TimeStampVector)this.vector, calendar);
    }

    public ColumnBinder visit(ArrowType.Interval type) {
        throw new UnsupportedOperationException("No column binder implemented for type " + type);
    }

    public ColumnBinder visit(ArrowType.Duration type) {
        throw new UnsupportedOperationException("No column binder implemented for type " + type);
    }
}

