/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Map;
import java.util.function.Function;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.types.pojo.ArrowType;

public final class JdbcToArrowConfig {
    public static final int DEFAULT_TARGET_BATCH_SIZE = 1024;
    public static final int NO_LIMIT_BATCH_SIZE = -1;
    private final Calendar calendar;
    private final BufferAllocator allocator;
    private final boolean includeMetadata;
    private final boolean reuseVectorSchemaRoot;
    private final Map<Integer, JdbcFieldInfo> arraySubTypesByColumnIndex;
    private final Map<String, JdbcFieldInfo> arraySubTypesByColumnName;
    private final Map<Integer, JdbcFieldInfo> explicitTypesByColumnIndex;
    private final Map<String, JdbcFieldInfo> explicitTypesByColumnName;
    private final Map<String, String> schemaMetadata;
    private final Map<Integer, Map<String, String>> columnMetadataByColumnIndex;
    private final RoundingMode bigDecimalRoundingMode;
    private final int targetBatchSize;
    private final Function<JdbcFieldInfo, ArrowType> jdbcToArrowTypeConverter;

    JdbcToArrowConfig(BufferAllocator allocator, Calendar calendar) {
        this(allocator, calendar, false, false, null, null, 1024, null, null);
    }

    JdbcToArrowConfig(BufferAllocator allocator, Calendar calendar, boolean includeMetadata, boolean reuseVectorSchemaRoot, Map<Integer, JdbcFieldInfo> arraySubTypesByColumnIndex, Map<String, JdbcFieldInfo> arraySubTypesByColumnName, int targetBatchSize, Function<JdbcFieldInfo, ArrowType> jdbcToArrowTypeConverter) {
        this(allocator, calendar, includeMetadata, reuseVectorSchemaRoot, arraySubTypesByColumnIndex, arraySubTypesByColumnName, targetBatchSize, jdbcToArrowTypeConverter, null);
    }

    JdbcToArrowConfig(BufferAllocator allocator, Calendar calendar, boolean includeMetadata, boolean reuseVectorSchemaRoot, Map<Integer, JdbcFieldInfo> arraySubTypesByColumnIndex, Map<String, JdbcFieldInfo> arraySubTypesByColumnName, int targetBatchSize, Function<JdbcFieldInfo, ArrowType> jdbcToArrowTypeConverter, RoundingMode bigDecimalRoundingMode) {
        this(allocator, calendar, includeMetadata, reuseVectorSchemaRoot, arraySubTypesByColumnIndex, arraySubTypesByColumnName, targetBatchSize, jdbcToArrowTypeConverter, null, null, null, null, bigDecimalRoundingMode);
    }

    JdbcToArrowConfig(BufferAllocator allocator, Calendar calendar, boolean includeMetadata, boolean reuseVectorSchemaRoot, Map<Integer, JdbcFieldInfo> arraySubTypesByColumnIndex, Map<String, JdbcFieldInfo> arraySubTypesByColumnName, int targetBatchSize, Function<JdbcFieldInfo, ArrowType> jdbcToArrowTypeConverter, Map<Integer, JdbcFieldInfo> explicitTypesByColumnIndex, Map<String, JdbcFieldInfo> explicitTypesByColumnName, Map<String, String> schemaMetadata, Map<Integer, Map<String, String>> columnMetadataByColumnIndex, RoundingMode bigDecimalRoundingMode) {
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory allocator cannot be null");
        this.allocator = allocator;
        this.calendar = calendar;
        this.includeMetadata = includeMetadata;
        this.reuseVectorSchemaRoot = reuseVectorSchemaRoot;
        this.arraySubTypesByColumnIndex = arraySubTypesByColumnIndex;
        this.arraySubTypesByColumnName = arraySubTypesByColumnName;
        this.targetBatchSize = targetBatchSize;
        this.explicitTypesByColumnIndex = explicitTypesByColumnIndex;
        this.explicitTypesByColumnName = explicitTypesByColumnName;
        this.schemaMetadata = schemaMetadata;
        this.columnMetadataByColumnIndex = columnMetadataByColumnIndex;
        this.bigDecimalRoundingMode = bigDecimalRoundingMode;
        this.jdbcToArrowTypeConverter = jdbcToArrowTypeConverter != null ? jdbcToArrowTypeConverter : jdbcFieldInfo -> JdbcToArrowUtils.getArrowTypeFromJdbcType(jdbcFieldInfo, calendar);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    public boolean shouldIncludeMetadata() {
        return this.includeMetadata;
    }

    public int getTargetBatchSize() {
        return this.targetBatchSize;
    }

    public boolean isReuseVectorSchemaRoot() {
        return this.reuseVectorSchemaRoot;
    }

    public Function<JdbcFieldInfo, ArrowType> getJdbcToArrowTypeConverter() {
        return this.jdbcToArrowTypeConverter;
    }

    public JdbcFieldInfo getArraySubTypeByColumnIndex(int index) {
        if (this.arraySubTypesByColumnIndex == null) {
            return null;
        }
        return this.arraySubTypesByColumnIndex.get(index);
    }

    public JdbcFieldInfo getArraySubTypeByColumnName(String name) {
        if (this.arraySubTypesByColumnName == null) {
            return null;
        }
        return this.arraySubTypesByColumnName.get(name);
    }

    public JdbcFieldInfo getExplicitTypeByColumnIndex(int index) {
        if (this.explicitTypesByColumnIndex == null) {
            return null;
        }
        return this.explicitTypesByColumnIndex.get(index);
    }

    public JdbcFieldInfo getExplicitTypeByColumnName(String name) {
        if (this.explicitTypesByColumnName == null) {
            return null;
        }
        return this.explicitTypesByColumnName.get(name);
    }

    public Map<String, String> getSchemaMetadata() {
        return this.schemaMetadata;
    }

    public Map<Integer, Map<String, String>> getColumnMetadataByColumnIndex() {
        return this.columnMetadataByColumnIndex;
    }

    public RoundingMode getBigDecimalRoundingMode() {
        return this.bigDecimalRoundingMode;
    }
}

