/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.binder;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.binder.BaseColumnBinder;
import org.apache.arrow.vector.BitVector;

public class BitBinder
extends BaseColumnBinder<BitVector> {
    public BitBinder(BitVector vector) {
        this(vector, 16);
    }

    public BitBinder(BitVector vector, int jdbcType) {
        super(vector, jdbcType);
    }

    @Override
    public void bind(PreparedStatement statement, int parameterIndex, int rowIndex) throws SQLException {
        int bitIndex;
        int byteIndex = rowIndex >> 3;
        byte b = ((BitVector)this.vector).getDataBuffer().getByte((long)byteIndex);
        int value = b >> (bitIndex = rowIndex & 7) & 1;
        statement.setBoolean(parameterIndex, value != 0);
    }
}

