/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.vector.SmallIntVector;

public class SmallIntConsumer {
    public static BaseConsumer<SmallIntVector> createConsumer(SmallIntVector vector, int index, boolean nullable) {
        if (nullable) {
            return new NullableSmallIntConsumer(vector, index);
        }
        return new NonNullableSmallIntConsumer(vector, index);
    }

    static class NonNullableSmallIntConsumer
    extends BaseConsumer<SmallIntVector> {
        public NonNullableSmallIntConsumer(SmallIntVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            short value = resultSet.getShort(this.columnIndexInResultSet);
            ((SmallIntVector)this.vector).set(this.currentIndex, value);
            ++this.currentIndex;
        }
    }

    static class NullableSmallIntConsumer
    extends BaseConsumer<SmallIntVector> {
        public NullableSmallIntConsumer(SmallIntVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            short value = resultSet.getShort(this.columnIndexInResultSet);
            if (!resultSet.wasNull()) {
                ((SmallIntVector)this.vector).set(this.currentIndex, value);
            }
            ++this.currentIndex;
        }
    }
}

