/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.TimeStampMilliTZVector;

public abstract class TimestampConsumer {
    public static JdbcConsumer<TimeStampMilliTZVector> createConsumer(TimeStampMilliTZVector vector, int index, boolean nullable, Calendar calendar) {
        if (nullable) {
            return new NullableTimestampConsumer(vector, index, calendar);
        }
        return new NonNullableTimestampConsumer(vector, index, calendar);
    }

    static class NonNullableTimestampConsumer
    extends BaseConsumer<TimeStampMilliTZVector> {
        protected final Calendar calendar;

        public NonNullableTimestampConsumer(TimeStampMilliTZVector vector, int index) {
            this(vector, index, null);
        }

        public NonNullableTimestampConsumer(TimeStampMilliTZVector vector, int index, Calendar calendar) {
            super(vector, index);
            this.calendar = calendar;
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            Timestamp timestamp = this.calendar == null ? resultSet.getTimestamp(this.columnIndexInResultSet) : resultSet.getTimestamp(this.columnIndexInResultSet, this.calendar);
            ((TimeStampMilliTZVector)this.vector).setSafe(this.currentIndex, timestamp.getTime());
            ++this.currentIndex;
        }
    }

    static class NullableTimestampConsumer
    extends BaseConsumer<TimeStampMilliTZVector> {
        protected final Calendar calendar;

        public NullableTimestampConsumer(TimeStampMilliTZVector vector, int index) {
            this(vector, index, null);
        }

        public NullableTimestampConsumer(TimeStampMilliTZVector vector, int index, Calendar calendar) {
            super(vector, index);
            this.calendar = calendar;
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            Timestamp timestamp;
            Timestamp timestamp2 = timestamp = this.calendar == null ? resultSet.getTimestamp(this.columnIndexInResultSet) : resultSet.getTimestamp(this.columnIndexInResultSet, this.calendar);
            if (!resultSet.wasNull()) {
                ((TimeStampMilliTZVector)this.vector).setSafe(this.currentIndex, timestamp.getTime());
            }
            ++this.currentIndex;
        }
    }
}

