/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.adapter.jdbc.consumer.CompositeJdbcConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Schema;

public class ArrowVectorIterator
implements Iterator<VectorSchemaRoot>,
AutoCloseable {
    private final ResultSet resultSet;
    private final JdbcToArrowConfig config;
    private final Schema schema;
    private final ResultSetMetaData rsmd;
    private final JdbcConsumer[] consumers;
    final CompositeJdbcConsumer compositeConsumer;
    private VectorSchemaRoot nextBatch;
    private final int targetBatchSize;

    private ArrowVectorIterator(ResultSet resultSet, JdbcToArrowConfig config) throws SQLException {
        this.resultSet = resultSet;
        this.config = config;
        this.schema = JdbcToArrowUtils.jdbcToArrowSchema(resultSet.getMetaData(), config);
        this.targetBatchSize = config.getTargetBatchSize();
        this.rsmd = resultSet.getMetaData();
        this.consumers = new JdbcConsumer[this.rsmd.getColumnCount()];
        this.compositeConsumer = new CompositeJdbcConsumer(this.consumers);
    }

    private void initialize() throws SQLException {
        for (int i = 1; i <= this.consumers.length; ++i) {
            this.consumers[i - 1] = JdbcToArrowUtils.getConsumer(this.resultSet, i, this.resultSet.getMetaData().getColumnType(i), null, this.config);
        }
        this.load(this.createVectorSchemaRoot());
    }

    public static ArrowVectorIterator create(ResultSet resultSet, JdbcToArrowConfig config) throws SQLException {
        ArrowVectorIterator iterator = new ArrowVectorIterator(resultSet, config);
        try {
            iterator.initialize();
            return iterator;
        }
        catch (Exception e) {
            iterator.close();
            throw new RuntimeException("Error occurred while creating iterator.", e);
        }
    }

    private void consumeData(VectorSchemaRoot root) {
        try {
            int readRowCount;
            for (readRowCount = 0; (this.targetBatchSize == -1 || readRowCount < this.targetBatchSize) && this.resultSet.next(); ++readRowCount) {
                this.compositeConsumer.consume(this.resultSet);
            }
            root.setRowCount(readRowCount);
        }
        catch (Exception e) {
            this.compositeConsumer.close();
            throw new RuntimeException("Error occurred while consuming data.", e);
        }
    }

    private VectorSchemaRoot createVectorSchemaRoot() {
        VectorSchemaRoot root = null;
        try {
            root = VectorSchemaRoot.create((Schema)this.schema, (BufferAllocator)this.config.getAllocator());
        }
        catch (Exception e) {
            if (root != null) {
                root.close();
            }
            throw new RuntimeException("Error occurred while creating schema root.", e);
        }
        return root;
    }

    private void load(VectorSchemaRoot root) throws SQLException {
        for (int i = 1; i <= this.consumers.length; ++i) {
            this.consumers[i - 1].resetValueVector(root.getVector(this.rsmd.getColumnName(i)));
        }
        this.consumeData(root);
        if (root.getRowCount() == 0) {
            root.close();
            this.nextBatch = null;
        } else {
            this.nextBatch = root;
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextBatch != null;
    }

    @Override
    public VectorSchemaRoot next() {
        Preconditions.checkArgument((boolean)this.hasNext());
        VectorSchemaRoot returned = this.nextBatch;
        try {
            this.load(this.createVectorSchemaRoot());
        }
        catch (Exception e) {
            this.close();
            throw new RuntimeException("Error occurred while getting next schema root.", e);
        }
        return returned;
    }

    @Override
    public void close() {
        if (this.nextBatch != null) {
            this.nextBatch.close();
        }
        this.compositeConsumer.close();
    }
}

