/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.Float4Vector;

public class FloatConsumer {
    public static JdbcConsumer<Float4Vector> createConsumer(Float4Vector vector, int index, boolean nullable) {
        if (nullable) {
            return new NullableFloatConsumer(vector, index);
        }
        return new NonNullableFloatConsumer(vector, index);
    }

    static class NonNullableFloatConsumer
    extends BaseConsumer<Float4Vector> {
        public NonNullableFloatConsumer(Float4Vector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            float value = resultSet.getFloat(this.columnIndexInResultSet);
            ((Float4Vector)this.vector).setSafe(this.currentIndex, value);
            ++this.currentIndex;
        }
    }

    static class NullableFloatConsumer
    extends BaseConsumer<Float4Vector> {
        public NullableFloatConsumer(Float4Vector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            float value = resultSet.getFloat(this.columnIndexInResultSet);
            if (!resultSet.wasNull()) {
                ((Float4Vector)this.vector).setSafe(this.currentIndex, value);
            }
            ++this.currentIndex;
        }
    }
}

