/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.IntVector;

public class IntConsumer
implements JdbcConsumer<IntVector> {
    private IntVector vector;
    private final int columnIndexInResultSet;
    private int currentIndex;

    public IntConsumer(IntVector vector, int index) {
        this.vector = vector;
        this.columnIndexInResultSet = index;
    }

    @Override
    public void consume(ResultSet resultSet) throws SQLException {
        int value = resultSet.getInt(this.columnIndexInResultSet);
        if (!resultSet.wasNull()) {
            this.vector.setSafe(this.currentIndex, value);
        }
        ++this.currentIndex;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    @Override
    public void resetValueVector(IntVector vector) {
        this.vector = vector;
        this.currentIndex = 0;
    }
}

