/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.VarCharVector;

public class VarCharConsumer
implements JdbcConsumer<VarCharVector> {
    private final int columnIndexInResultSet;
    private VarCharVector vector;
    private int currentIndex;

    public VarCharConsumer(VarCharVector vector, int index) {
        this.vector = vector;
        this.columnIndexInResultSet = index;
    }

    @Override
    public void consume(ResultSet resultSet) throws SQLException {
        String value = resultSet.getString(this.columnIndexInResultSet);
        if (!resultSet.wasNull()) {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            this.vector.setSafe(this.currentIndex, bytes);
        }
        ++this.currentIndex;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    @Override
    public void resetValueVector(VarCharVector vector) {
        this.vector = vector;
        this.currentIndex = 0;
    }
}

