/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.Float4Vector;

public class FloatConsumer
implements JdbcConsumer<Float4Vector> {
    private Float4Vector vector;
    private final int columnIndexInResultSet;
    private int currentIndex;

    public FloatConsumer(Float4Vector vector, int index) {
        this.vector = vector;
        this.columnIndexInResultSet = index;
    }

    @Override
    public void consume(ResultSet resultSet) throws SQLException {
        float value = resultSet.getFloat(this.columnIndexInResultSet);
        if (!resultSet.wasNull()) {
            this.vector.setSafe(this.currentIndex, value);
        }
        ++this.currentIndex;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    @Override
    public void resetValueVector(Float4Vector vector) {
        this.vector = vector;
        this.currentIndex = 0;
    }
}

