/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.Float8Vector;

public class DoubleConsumer
implements JdbcConsumer<Float8Vector> {
    private Float8Vector vector;
    private final int columnIndexInResultSet;
    private int currentIndex;

    public DoubleConsumer(Float8Vector vector, int index) {
        this.vector = vector;
        this.columnIndexInResultSet = index;
    }

    @Override
    public void consume(ResultSet resultSet) throws SQLException {
        double value = resultSet.getDouble(this.columnIndexInResultSet);
        if (!resultSet.wasNull()) {
            this.vector.setSafe(this.currentIndex, value);
        }
        ++this.currentIndex;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    @Override
    public void resetValueVector(Float8Vector vector) {
        this.vector = vector;
        this.currentIndex = 0;
    }
}

