/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.io.IOException;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.BinaryConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.VarBinaryVector;

public class BlobConsumer
implements JdbcConsumer<VarBinaryVector> {
    private final int columnIndexInResultSet;
    private BinaryConsumer delegate;

    public BlobConsumer(BinaryConsumer delegate, int index) {
        this.columnIndexInResultSet = index;
        this.delegate = delegate;
    }

    @Override
    public void consume(ResultSet resultSet) throws SQLException, IOException {
        Blob blob = resultSet.getBlob(this.columnIndexInResultSet);
        if (blob != null) {
            this.delegate.consume(blob.getBinaryStream());
        }
        this.delegate.moveWriterPosition();
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    @Override
    public void resetValueVector(VarBinaryVector vector) {
        this.delegate = new BinaryConsumer(vector, this.columnIndexInResultSet);
    }
}

