/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import io.netty.buffer.ArrowBuf;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.VarBinaryVector;

public class BinaryConsumer
implements JdbcConsumer<VarBinaryVector> {
    private static final int BUFFER_SIZE = 1024;
    private VarBinaryVector vector;
    private final int columnIndexInResultSet;
    private int currentIndex;

    public BinaryConsumer(VarBinaryVector vector, int index) {
        if (vector != null) {
            vector.allocateNewSafe();
        }
        this.vector = vector;
        this.columnIndexInResultSet = index;
    }

    public void consume(InputStream is) throws IOException {
        if (is != null) {
            int read;
            byte[] bytes = new byte[1024];
            int totalBytes = 0;
            ArrowBuf dataBuffer = this.vector.getDataBuffer();
            ArrowBuf offsetBuffer = this.vector.getOffsetBuffer();
            int startIndex = offsetBuffer.getInt(this.currentIndex * 4);
            while ((read = is.read(bytes)) != -1) {
                while (dataBuffer.writerIndex() + read > dataBuffer.capacity()) {
                    this.vector.reallocDataBuffer();
                }
                PlatformDependent.copyMemory((byte[])bytes, (int)0, (long)(dataBuffer.memoryAddress() + (long)startIndex + (long)totalBytes), (long)read);
                totalBytes += read;
            }
            offsetBuffer.setInt((this.currentIndex + 1) * 4, startIndex + totalBytes);
            BitVectorHelper.setValidityBitToOne((ArrowBuf)this.vector.getValidityBuffer(), (int)this.currentIndex);
            this.vector.setLastSet(this.currentIndex);
        }
    }

    @Override
    public void consume(ResultSet resultSet) throws SQLException, IOException {
        InputStream is = resultSet.getBinaryStream(this.columnIndexInResultSet);
        if (!resultSet.wasNull()) {
            this.consume(is);
        }
        ++this.currentIndex;
    }

    public void moveWriterPosition() {
        ++this.currentIndex;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    @Override
    public void resetValueVector(VarBinaryVector vector) {
        this.vector = vector;
        this.vector.allocateNewSafe();
        this.currentIndex = 0;
    }
}

