/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import com.google.common.base.Preconditions;
import java.util.Calendar;
import java.util.Map;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.memory.BaseAllocator;

public final class JdbcToArrowConfig {
    private Calendar calendar;
    private BaseAllocator allocator;
    private boolean includeMetadata;
    private Map<Integer, JdbcFieldInfo> arraySubTypesByColumnIndex;
    private Map<String, JdbcFieldInfo> arraySubTypesByColumnName;

    JdbcToArrowConfig(BaseAllocator allocator, Calendar calendar) {
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory allocator cannot be null");
        this.allocator = allocator;
        this.calendar = calendar;
        this.includeMetadata = false;
        this.arraySubTypesByColumnIndex = null;
        this.arraySubTypesByColumnName = null;
    }

    JdbcToArrowConfig(BaseAllocator allocator, Calendar calendar, boolean includeMetadata, Map<Integer, JdbcFieldInfo> arraySubTypesByColumnIndex, Map<String, JdbcFieldInfo> arraySubTypesByColumnName) {
        this(allocator, calendar);
        this.includeMetadata = includeMetadata;
        this.arraySubTypesByColumnIndex = arraySubTypesByColumnIndex;
        this.arraySubTypesByColumnName = arraySubTypesByColumnName;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public BaseAllocator getAllocator() {
        return this.allocator;
    }

    public boolean shouldIncludeMetadata() {
        return this.includeMetadata;
    }

    public JdbcFieldInfo getArraySubTypeByColumnIndex(int index) {
        if (this.arraySubTypesByColumnIndex == null) {
            return null;
        }
        return this.arraySubTypesByColumnIndex.get(index);
    }

    public JdbcFieldInfo getArraySubTypeByColumnName(String name) {
        if (this.arraySubTypesByColumnName == null) {
            return null;
        }
        return this.arraySubTypesByColumnName.get(name);
    }
}

