/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.example.integration;

import io.netty.buffer.ArrowBuf;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.flight.AsyncPutListener;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.PutResult;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.JsonFileReader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Validator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IntegrationTestClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrationTestClient.class);
    private final Options options = new Options();

    private IntegrationTestClient() {
        this.options.addOption("j", "json", true, "json file");
        this.options.addOption("host", true, "The host to connect to.");
        this.options.addOption("port", true, "The port to connect to.");
    }

    public static void main(String[] args) {
        try {
            new IntegrationTestClient().run(args);
        }
        catch (ParseException e) {
            IntegrationTestClient.fatalError("Invalid parameters", e);
        }
        catch (IOException e) {
            IntegrationTestClient.fatalError("Error accessing files", e);
        }
    }

    private static void fatalError(String message, Throwable e) {
        System.err.println(message);
        System.err.println(e.getMessage());
        LOGGER.error(message, e);
        System.exit(1);
    }

    private void run(String[] args) throws ParseException, IOException {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(this.options, args, false);
        String host = cmd.getOptionValue("host", "localhost");
        int port = Integer.parseInt(cmd.getOptionValue("port", "31337"));
        Location defaultLocation = Location.forGrpcInsecure(host, port);
        try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
             FlightClient client = FlightClient.builder((BufferAllocator)allocator, defaultLocation).build();){
            String inputPath = cmd.getOptionValue("j");
            IntegrationTestClient.testStream((BufferAllocator)allocator, defaultLocation, client, inputPath);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void testStream(BufferAllocator allocator, Location server, FlightClient client, String inputPath) throws IOException {
        VectorSchemaRoot jsonRoot;
        FlightDescriptor descriptor = FlightDescriptor.path(inputPath);
        try (JsonFileReader reader = new JsonFileReader(new File(inputPath), allocator);
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)reader.start(), (BufferAllocator)allocator);){
            jsonRoot = VectorSchemaRoot.create((Schema)root.getSchema(), (BufferAllocator)allocator);
            VectorUnloader unloader = new VectorUnloader(root);
            VectorLoader jsonLoader = new VectorLoader(jsonRoot);
            FlightClient.ClientStreamListener stream = client.startPut(descriptor, root, (DictionaryProvider)reader, new AsyncPutListener(){
                int counter = 0;

                @Override
                public void onNext(PutResult val) {
                    byte[] metadataRaw = new byte[val.getApplicationMetadata().readableBytes()];
                    val.getApplicationMetadata().readBytes(metadataRaw);
                    String metadata = new String(metadataRaw, StandardCharsets.UTF_8);
                    if (!Integer.toString(this.counter).equals(metadata)) {
                        throw new RuntimeException(String.format("Invalid ACK from server. Expected '%d' but got '%s'.", this.counter, metadata));
                    }
                    ++this.counter;
                }
            }, new CallOption[0]);
            int counter = 0;
            while (reader.read(root)) {
                byte[] rawMetadata = Integer.toString(counter).getBytes(StandardCharsets.UTF_8);
                ArrowBuf metadata = allocator.buffer(rawMetadata.length);
                metadata.writeBytes(rawMetadata);
                stream.putNext(metadata);
                try (ArrowRecordBatch arb = unloader.getRecordBatch();){
                    jsonLoader.load(arb);
                }
                root.clear();
                ++counter;
            }
            stream.completed();
            stream.getResult();
        }
        FlightInfo info = client.getInfo(descriptor, new CallOption[0]);
        List<FlightEndpoint> endpoints = info.getEndpoints();
        if (endpoints.isEmpty()) {
            throw new RuntimeException("No endpoints returned from Flight server.");
        }
        for (FlightEndpoint endpoint : info.getEndpoints()) {
            List<Location> locations = endpoint.getLocations();
            if (locations.size() == 0) {
                locations = Collections.singletonList(server);
            }
            for (Location location : locations) {
                System.out.println("Verifying location " + location.getUri());
                try {
                    FlightClient readClient = FlightClient.builder(allocator, location).build();
                    Throwable throwable = null;
                    try {
                        FlightStream stream = readClient.getStream(endpoint.getTicket(), new CallOption[0]);
                        Throwable throwable2 = null;
                        try {
                            VectorSchemaRoot root = stream.getRoot();
                            Throwable throwable3 = null;
                            try {
                                VectorSchemaRoot downloadedRoot = VectorSchemaRoot.create((Schema)root.getSchema(), (BufferAllocator)allocator);
                                Throwable throwable4 = null;
                                try {
                                    VectorLoader loader = new VectorLoader(downloadedRoot);
                                    VectorUnloader unloader = new VectorUnloader(root);
                                    while (stream.next()) {
                                        ArrowRecordBatch arb = unloader.getRecordBatch();
                                        Throwable throwable5 = null;
                                        try {
                                            loader.load(arb);
                                        }
                                        catch (Throwable throwable6) {
                                            throwable5 = throwable6;
                                            throw throwable6;
                                        }
                                        finally {
                                            if (arb == null) continue;
                                            IntegrationTestClient.$closeResource(throwable5, (AutoCloseable)arb);
                                        }
                                    }
                                    Validator.compareVectorSchemaRoot((VectorSchemaRoot)jsonRoot, (VectorSchemaRoot)downloadedRoot);
                                }
                                catch (Throwable throwable7) {
                                    throwable4 = throwable7;
                                    throw throwable7;
                                }
                                finally {
                                    if (downloadedRoot == null) continue;
                                    IntegrationTestClient.$closeResource(throwable4, (AutoCloseable)downloadedRoot);
                                }
                            }
                            catch (Throwable throwable8) {
                                throwable3 = throwable8;
                                throw throwable8;
                            }
                            finally {
                                if (root == null) continue;
                                IntegrationTestClient.$closeResource(throwable3, (AutoCloseable)root);
                            }
                        }
                        catch (Throwable throwable9) {
                            throwable2 = throwable9;
                            throw throwable9;
                        }
                        finally {
                            if (stream == null) continue;
                            IntegrationTestClient.$closeResource(throwable2, stream);
                        }
                    }
                    catch (Throwable throwable10) {
                        throwable = throwable10;
                        throw throwable10;
                    }
                    finally {
                        if (readClient == null) continue;
                        IntegrationTestClient.$closeResource(throwable, readClient);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        jsonRoot.close();
    }
}

