/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.example;

import java.io.IOException;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.example.InMemoryStore;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleFlightServer
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ExampleFlightServer.class);
    private final FlightServer flightServer;
    private final Location location;
    private final BufferAllocator allocator;
    private final InMemoryStore mem;

    public ExampleFlightServer(BufferAllocator allocator, Location location) {
        this.allocator = allocator.newChildAllocator("flight-server", 0L, Long.MAX_VALUE);
        this.location = location;
        this.mem = new InMemoryStore(this.allocator, location);
        this.flightServer = FlightServer.builder(allocator, location, this.mem).build();
    }

    public Location getLocation() {
        return this.location;
    }

    public void start() throws IOException {
        this.flightServer.start();
    }

    public void awaitTermination() throws InterruptedException {
        this.flightServer.awaitTermination();
    }

    public InMemoryStore getStore() {
        return this.mem;
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.mem, this.flightServer, this.allocator});
    }

    public static void main(String[] args) throws Exception {
        RootAllocator a = new RootAllocator(Long.MAX_VALUE);
        ExampleFlightServer efs = new ExampleFlightServer((BufferAllocator)a, Location.forGrpcInsecure("localhost", 12233));
        efs.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ExampleFlightServer.lambda$main$0(efs, (BufferAllocator)a)));
        efs.awaitTermination();
    }

    private static /* synthetic */ void lambda$main$0(ExampleFlightServer efs, BufferAllocator a) {
        try {
            System.out.println("\nExiting...");
            AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{efs, a});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

