/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.auth;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.Optional;
import org.apache.arrow.flight.auth.AuthConstants;
import org.apache.arrow.flight.auth.ServerAuthHandler;

public class ServerAuthInterceptor
implements ServerInterceptor {
    private final ServerAuthHandler authHandler;

    public ServerAuthInterceptor(ServerAuthHandler authHandler) {
        this.authHandler = authHandler;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        if (!call.getMethodDescriptor().getFullMethodName().equals(AuthConstants.HANDSHAKE_DESCRIPTOR_NAME)) {
            Optional<String> peerIdentity = this.isValid(headers);
            if (!peerIdentity.isPresent()) {
                call.close(Status.UNAUTHENTICATED, new Metadata());
                return new NoopServerCallListener();
            }
            return Contexts.interceptCall((Context)Context.current().withValue(AuthConstants.PEER_IDENTITY_KEY, (Object)peerIdentity.get()), call, (Metadata)headers, next);
        }
        return next.startCall(call, headers);
    }

    private Optional<String> isValid(Metadata headers) {
        byte[] token = (byte[])headers.get(AuthConstants.TOKEN_KEY);
        return this.authHandler.isValid(token);
    }

    private static class NoopServerCallListener<T>
    extends ServerCall.Listener<T> {
        private NoopServerCallListener() {
        }
    }
}

