/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.grpc;

import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.FlightStatusCode;

public class StatusUtils {
    private StatusUtils() {
        throw new AssertionError((Object)"Do not instantiate this class.");
    }

    public static Status.Code toGrpcStatusCode(FlightStatusCode code) {
        switch (code) {
            case UNKNOWN: {
                return Status.Code.UNKNOWN;
            }
            case INTERNAL: {
                return Status.Code.INTERNAL;
            }
            case INVALID_ARGUMENT: {
                return Status.Code.INVALID_ARGUMENT;
            }
            case TIMED_OUT: {
                return Status.Code.DEADLINE_EXCEEDED;
            }
            case NOT_FOUND: {
                return Status.Code.NOT_FOUND;
            }
            case ALREADY_EXISTS: {
                return Status.Code.ALREADY_EXISTS;
            }
            case CANCELLED: {
                return Status.Code.CANCELLED;
            }
            case UNAUTHENTICATED: {
                return Status.Code.UNAUTHENTICATED;
            }
            case UNAUTHORIZED: {
                return Status.Code.PERMISSION_DENIED;
            }
            case UNIMPLEMENTED: {
                return Status.Code.UNIMPLEMENTED;
            }
            case UNAVAILABLE: {
                return Status.Code.UNAVAILABLE;
            }
        }
        return Status.Code.UNKNOWN;
    }

    public static FlightStatusCode fromGrpcStatusCode(Status.Code code) {
        switch (code) {
            case CANCELLED: {
                return FlightStatusCode.CANCELLED;
            }
            case UNKNOWN: {
                return FlightStatusCode.UNKNOWN;
            }
            case INVALID_ARGUMENT: {
                return FlightStatusCode.INVALID_ARGUMENT;
            }
            case DEADLINE_EXCEEDED: {
                return FlightStatusCode.TIMED_OUT;
            }
            case NOT_FOUND: {
                return FlightStatusCode.NOT_FOUND;
            }
            case ALREADY_EXISTS: {
                return FlightStatusCode.ALREADY_EXISTS;
            }
            case PERMISSION_DENIED: {
                return FlightStatusCode.UNAUTHORIZED;
            }
            case RESOURCE_EXHAUSTED: {
                return FlightStatusCode.INVALID_ARGUMENT;
            }
            case FAILED_PRECONDITION: {
                return FlightStatusCode.INVALID_ARGUMENT;
            }
            case ABORTED: {
                return FlightStatusCode.INTERNAL;
            }
            case OUT_OF_RANGE: {
                return FlightStatusCode.INVALID_ARGUMENT;
            }
            case UNIMPLEMENTED: {
                return FlightStatusCode.UNIMPLEMENTED;
            }
            case INTERNAL: {
                return FlightStatusCode.INTERNAL;
            }
            case UNAVAILABLE: {
                return FlightStatusCode.UNAVAILABLE;
            }
            case DATA_LOSS: {
                return FlightStatusCode.INTERNAL;
            }
            case UNAUTHENTICATED: {
                return FlightStatusCode.UNAUTHENTICATED;
            }
        }
        return FlightStatusCode.UNKNOWN;
    }

    public static CallStatus fromGrpcStatus(Status status) {
        return new CallStatus(StatusUtils.fromGrpcStatusCode(status.getCode()), status.getCause(), status.getDescription());
    }

    public static Status toGrpcStatus(CallStatus status) {
        return StatusUtils.toGrpcStatusCode(status.code()).toStatus().withDescription(status.description()).withCause(status.cause());
    }

    public static FlightRuntimeException fromGrpcRuntimeException(StatusRuntimeException sre) {
        return StatusUtils.fromGrpcStatus(sre.getStatus()).toRuntimeException();
    }

    public static FlightRuntimeException fromThrowable(Throwable t) {
        if (t instanceof StatusRuntimeException) {
            return StatusUtils.fromGrpcRuntimeException((StatusRuntimeException)t);
        }
        if (t instanceof FlightRuntimeException) {
            return (FlightRuntimeException)t;
        }
        return CallStatus.UNKNOWN.withCause(t).withDescription(t.getMessage()).toRuntimeException();
    }

    public static Throwable toGrpcException(Throwable ex) {
        if (ex instanceof StatusRuntimeException) {
            return ex;
        }
        if (ex instanceof StatusException) {
            return ex;
        }
        if (ex instanceof FlightRuntimeException) {
            FlightRuntimeException fre = (FlightRuntimeException)ex;
            return StatusUtils.toGrpcStatus(fre.status()).asRuntimeException();
        }
        return Status.INTERNAL.withCause(ex).withDescription("There was an error servicing your request.").asRuntimeException();
    }

    public static <FROM, TO> Iterator<TO> wrapIterator(final Iterator<FROM> fromIterator, final Function<? super FROM, ? extends TO> transformer) {
        Objects.requireNonNull(fromIterator);
        Objects.requireNonNull(transformer);
        return new Iterator<TO>(){

            @Override
            public boolean hasNext() {
                try {
                    return fromIterator.hasNext();
                }
                catch (StatusRuntimeException e) {
                    throw StatusUtils.fromGrpcRuntimeException(e);
                }
            }

            @Override
            public TO next() {
                try {
                    return transformer.apply(fromIterator.next());
                }
                catch (StatusRuntimeException e) {
                    throw StatusUtils.fromGrpcRuntimeException(e);
                }
            }
        };
    }
}

