/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.example.integration;

import io.netty.buffer.ArrowBuf;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.flight.AsyncPutListener;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.PutResult;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.JsonFileReader;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Validator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IntegrationTestClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrationTestClient.class);
    private final Options options = new Options();

    private IntegrationTestClient() {
        this.options.addOption("j", "json", true, "json file");
        this.options.addOption("host", true, "The host to connect to.");
        this.options.addOption("port", true, "The port to connect to.");
    }

    public static void main(String[] args) {
        try {
            new IntegrationTestClient().run(args);
        }
        catch (ParseException e) {
            IntegrationTestClient.fatalError("Invalid parameters", e);
        }
        catch (IOException e) {
            IntegrationTestClient.fatalError("Error accessing files", e);
        }
    }

    private static void fatalError(String message, Throwable e) {
        System.err.println(message);
        System.err.println(e.getMessage());
        LOGGER.error(message, e);
        System.exit(1);
    }

    private void run(String[] args) throws ParseException, IOException {
        VectorSchemaRoot jsonRoot;
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(this.options, args, false);
        String host = cmd.getOptionValue("host", "localhost");
        int port = Integer.parseInt(cmd.getOptionValue("port", "31337"));
        RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
        Location defaultLocation = Location.forGrpcInsecure(host, port);
        FlightClient client = FlightClient.builder((BufferAllocator)allocator, defaultLocation).build();
        String inputPath = cmd.getOptionValue("j");
        FlightDescriptor descriptor = FlightDescriptor.path(inputPath);
        try (JsonFileReader reader = new JsonFileReader(new File(inputPath), (BufferAllocator)allocator);
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)reader.start(), (BufferAllocator)allocator);){
            jsonRoot = VectorSchemaRoot.create((Schema)root.getSchema(), (BufferAllocator)allocator);
            VectorUnloader unloader = new VectorUnloader(root);
            VectorLoader jsonLoader = new VectorLoader(jsonRoot);
            FlightClient.ClientStreamListener stream = client.startPut(descriptor, root, (DictionaryProvider)reader, new AsyncPutListener(){
                int counter = 0;

                @Override
                public void onNext(PutResult val) {
                    byte[] metadataRaw = new byte[val.getApplicationMetadata().readableBytes()];
                    val.getApplicationMetadata().readBytes(metadataRaw);
                    String metadata = new String(metadataRaw, StandardCharsets.UTF_8);
                    if (!Integer.toString(this.counter).equals(metadata)) {
                        throw new RuntimeException(String.format("Invalid ACK from server. Expected '%d' but got '%s'.", this.counter, metadata));
                    }
                    ++this.counter;
                }
            }, new CallOption[0]);
            int counter = 0;
            while (reader.read(root)) {
                byte[] rawMetadata = Integer.toString(counter).getBytes(StandardCharsets.UTF_8);
                ArrowBuf metadata = allocator.buffer(rawMetadata.length);
                metadata.writeBytes(rawMetadata);
                stream.putNext(metadata);
                jsonLoader.load(unloader.getRecordBatch());
                root.clear();
                ++counter;
            }
            stream.completed();
            stream.getResult();
        }
        FlightInfo info = client.getInfo(descriptor, new CallOption[0]);
        List<FlightEndpoint> endpoints = info.getEndpoints();
        if (endpoints.isEmpty()) {
            throw new RuntimeException("No endpoints returned from Flight server.");
        }
        for (FlightEndpoint endpoint : info.getEndpoints()) {
            List<Location> locations = endpoint.getLocations();
            if (locations.size() == 0) {
                locations = Collections.singletonList(defaultLocation);
            }
            for (Location location : locations) {
                VectorSchemaRoot downloadedRoot;
                System.out.println("Verifying location " + location.getUri());
                FlightClient readClient = FlightClient.builder((BufferAllocator)allocator, location).build();
                FlightStream stream = readClient.getStream(endpoint.getTicket(), new CallOption[0]);
                try (VectorSchemaRoot root = stream.getRoot();){
                    downloadedRoot = VectorSchemaRoot.create((Schema)root.getSchema(), (BufferAllocator)allocator);
                    VectorLoader loader = new VectorLoader(downloadedRoot);
                    VectorUnloader unloader = new VectorUnloader(root);
                    while (stream.next()) {
                        loader.load(unloader.getRecordBatch());
                    }
                }
                Validator.compareVectorSchemaRoot((VectorSchemaRoot)jsonRoot, (VectorSchemaRoot)downloadedRoot);
            }
        }
    }
}

