/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Consumer;
import org.apache.arrow.flight.ArrowMessage;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.DictionaryUtility;

final class DictionaryUtils {
    private DictionaryUtils() {
        throw new UnsupportedOperationException("Do not instantiate this class.");
    }

    static Schema generateSchemaMessages(Schema originalSchema, FlightDescriptor descriptor, DictionaryProvider provider, Consumer<ArrowMessage> messageCallback) {
        ArrayList<Field> fields = new ArrayList<Field>(originalSchema.getFields().size());
        HashSet dictionaryIds = new HashSet();
        for (Field field : originalSchema.getFields()) {
            fields.add(DictionaryUtility.toMessageFormat((Field)field, (DictionaryProvider)provider, dictionaryIds));
        }
        Schema schema = new Schema(fields, originalSchema.getCustomMetadata());
        messageCallback.accept(new ArrowMessage(descriptor == null ? null : descriptor.toProtocol(), schema));
        for (Long id : dictionaryIds) {
            Dictionary dictionary = provider.lookup(id.longValue());
            FieldVector vector = dictionary.getVector();
            int count = vector.getValueCount();
            VectorSchemaRoot dictRoot = new VectorSchemaRoot(Collections.singletonList(vector.getField()), Collections.singletonList(vector), count);
            VectorUnloader unloader = new VectorUnloader(dictRoot);
            ArrowDictionaryBatch dictionaryBatch = new ArrowDictionaryBatch(id.longValue(), unloader.getRecordBatch());
            Throwable throwable = null;
            try {
                messageCallback.accept(new ArrowMessage(dictionaryBatch));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dictionaryBatch == null) continue;
                if (throwable != null) {
                    try {
                        dictionaryBatch.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dictionaryBatch.close();
            }
        }
        return schema;
    }
}

