/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.stub.StreamObserver;
import io.netty.buffer.ArrowBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import org.apache.arrow.flight.ArrowMessage;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.DictionaryUtility;

public class FlightStream
implements AutoCloseable {
    private final Object DONE = new Object();
    private final Object DONE_EX = new Object();
    private final BufferAllocator allocator;
    private final Cancellable cancellable;
    private final LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue();
    private final SettableFuture<VectorSchemaRoot> root = SettableFuture.create();
    private final int pendingTarget;
    private final Requestor requestor;
    private volatile int pending = 1;
    private boolean completed = false;
    private volatile VectorSchemaRoot fulfilledRoot;
    private DictionaryProvider.MapDictionaryProvider dictionaries;
    private volatile VectorLoader loader;
    private volatile Throwable ex;
    private volatile FlightDescriptor descriptor;
    private volatile Schema schema;
    private volatile ArrowBuf applicationMetadata = null;

    public FlightStream(BufferAllocator allocator, int pendingTarget, Cancellable cancellable, Requestor requestor) {
        this.allocator = allocator;
        this.pendingTarget = pendingTarget;
        this.cancellable = cancellable;
        this.requestor = requestor;
        this.dictionaries = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public DictionaryProvider getDictionaryProvider() {
        return this.dictionaries;
    }

    public FlightDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void close() throws Exception {
        if (!this.completed && this.cancellable != null) {
            this.cancel("Stream closed before end.", null);
        }
        List closeables = ImmutableList.copyOf((Object[])this.queue.toArray()).stream().filter(t -> AutoCloseable.class.isAssignableFrom(t.getClass())).map(t -> (AutoCloseable)t).collect(Collectors.toList());
        AutoCloseables.close((Iterable)Iterables.concat(closeables, (Iterable)(this.applicationMetadata != null ? ImmutableList.of((Object)this.root.get(), (Object)this.applicationMetadata) : ImmutableList.of((Object)this.root.get()))));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean next() {
        try {
            ((VectorSchemaRoot)this.root.get()).clear();
            if (this.completed && this.queue.isEmpty()) {
                return false;
            }
            --this.pending;
            this.requestOutstanding();
            Object data = this.queue.take();
            if (this.DONE == data) {
                this.queue.put(this.DONE);
                this.completed = true;
                return false;
            }
            if (this.DONE_EX == data) {
                this.queue.put(this.DONE_EX);
                if (!(this.ex instanceof Exception)) throw new Exception(this.ex);
                throw (Exception)this.ex;
            }
            try (ArrowMessage msg = (ArrowMessage)data;){
                if (msg.getMessageType() == ArrowMessage.HeaderType.RECORD_BATCH) {
                    try (ArrowRecordBatch arb = msg.asRecordBatch();){
                        this.loader.load(arb);
                    }
                    if (this.applicationMetadata != null) {
                        this.applicationMetadata.close();
                    }
                    this.applicationMetadata = msg.getApplicationMetadata();
                    if (this.applicationMetadata != null) {
                        this.applicationMetadata.getReferenceManager().retain();
                    }
                } else {
                    if (msg.getMessageType() != ArrowMessage.HeaderType.DICTIONARY_BATCH) throw new UnsupportedOperationException("Message type is unsupported: " + (Object)((Object)msg.getMessageType()));
                    try (ArrowDictionaryBatch arb = msg.asDictionaryBatch();){
                        long id = arb.getDictionaryId();
                        Dictionary dictionary = this.dictionaries.lookup(id);
                        if (dictionary == null) {
                            throw new IllegalArgumentException("Dictionary not defined in schema: ID " + id);
                        }
                        FieldVector vector = dictionary.getVector();
                        VectorSchemaRoot dictionaryRoot = new VectorSchemaRoot(Collections.singletonList(vector.getField()), Collections.singletonList(vector), 0);
                        VectorLoader dictionaryLoader = new VectorLoader(dictionaryRoot);
                        dictionaryLoader.load(arb.getDictionary());
                    }
                    boolean bl = this.next();
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public VectorSchemaRoot getRoot() {
        try {
            return (VectorSchemaRoot)this.root.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public ArrowBuf getLatestMetadata() {
        return this.applicationMetadata;
    }

    private synchronized void requestOutstanding() {
        if (this.pending < this.pendingTarget) {
            this.requestor.request(this.pendingTarget - this.pending);
            this.pending = this.pendingTarget;
        }
    }

    public void cancel(String message, Throwable exception) {
        if (this.cancellable == null) {
            throw new UnsupportedOperationException("Streams cannot be cancelled that are produced by client. Instead, server should reject incoming messages.");
        }
        this.cancellable.cancel(message, exception);
    }

    StreamObserver<ArrowMessage> asObserver() {
        return new Observer();
    }

    public static interface Requestor {
        public void request(int var1);
    }

    public static interface Cancellable {
        public void cancel(String var1, Throwable var2);
    }

    private class Observer
    implements StreamObserver<ArrowMessage> {
        public void onNext(ArrowMessage msg) {
            FlightStream.this.requestOutstanding();
            switch (msg.getMessageType()) {
                case SCHEMA: {
                    FlightStream.this.schema = msg.asSchema();
                    ArrayList<Field> fields = new ArrayList<Field>();
                    HashMap dictionaryMap = new HashMap();
                    for (Field field : FlightStream.this.schema.getFields()) {
                        Field updatedField = DictionaryUtility.toMemoryFormat((Field)field, (BufferAllocator)FlightStream.this.allocator, dictionaryMap);
                        fields.add(updatedField);
                    }
                    for (Map.Entry entry : dictionaryMap.entrySet()) {
                        FlightStream.this.dictionaries.put((Dictionary)entry.getValue());
                    }
                    FlightStream.this.schema = new Schema(fields, FlightStream.this.schema.getCustomMetadata());
                    FlightStream.this.fulfilledRoot = VectorSchemaRoot.create((Schema)FlightStream.this.schema, (BufferAllocator)FlightStream.this.allocator);
                    FlightStream.this.loader = new VectorLoader(FlightStream.this.fulfilledRoot);
                    FlightStream.this.descriptor = msg.getDescriptor() != null ? new FlightDescriptor(msg.getDescriptor()) : null;
                    FlightStream.this.root.set((Object)FlightStream.this.fulfilledRoot);
                    break;
                }
                case RECORD_BATCH: {
                    FlightStream.this.queue.add(msg);
                    break;
                }
                case DICTIONARY_BATCH: {
                    FlightStream.this.queue.add(msg);
                    break;
                }
                default: {
                    FlightStream.this.queue.add(FlightStream.this.DONE_EX);
                    FlightStream.this.ex = new UnsupportedOperationException("Unable to handle message of type: " + (Object)((Object)msg.getMessageType()));
                }
            }
        }

        public void onError(Throwable t) {
            FlightStream.this.ex = t;
            FlightStream.this.queue.add(FlightStream.this.DONE_EX);
            FlightStream.this.root.setException(t);
        }

        public void onCompleted() {
            FlightStream.this.queue.add(FlightStream.this.DONE);
        }
    }
}

