/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.Schema;

public class FlightInfo {
    private Schema schema;
    private FlightDescriptor descriptor;
    private List<FlightEndpoint> endpoints;
    private final long bytes;
    private final long records;

    public FlightInfo(Schema schema, FlightDescriptor descriptor, List<FlightEndpoint> endpoints, long bytes, long records) {
        this.schema = schema;
        this.descriptor = descriptor;
        this.endpoints = endpoints;
        this.bytes = bytes;
        this.records = records;
    }

    FlightInfo(Flight.FlightInfo pbFlightInfo) throws URISyntaxException {
        try {
            ByteBuffer schemaBuf = pbFlightInfo.getSchema().asReadOnlyByteBuffer();
            this.schema = pbFlightInfo.getSchema().size() > 0 ? MessageSerializer.deserializeSchema((ReadChannel)new ReadChannel(Channels.newChannel((InputStream)new ByteBufferBackedInputStream(schemaBuf)))) : new Schema((Iterable)ImmutableList.of());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.descriptor = new FlightDescriptor(pbFlightInfo.getFlightDescriptor());
        this.endpoints = new ArrayList<FlightEndpoint>();
        for (Flight.FlightEndpoint endpoint : pbFlightInfo.getEndpointList()) {
            this.endpoints.add(new FlightEndpoint(endpoint));
        }
        this.bytes = pbFlightInfo.getTotalBytes();
        this.records = pbFlightInfo.getTotalRecords();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public long getBytes() {
        return this.bytes;
    }

    public long getRecords() {
        return this.records;
    }

    public FlightDescriptor getDescriptor() {
        return this.descriptor;
    }

    public List<FlightEndpoint> getEndpoints() {
        return this.endpoints;
    }

    Flight.FlightInfo toProtocol() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MessageSerializer.serialize((WriteChannel)new WriteChannel(Channels.newChannel(baos)), (Schema)this.schema);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Flight.FlightInfo.newBuilder().addAllEndpoint(this.endpoints.stream().map(t -> t.toProtocol()).collect(Collectors.toList())).setSchema(ByteString.copyFrom((byte[])baos.toByteArray())).setFlightDescriptor(this.descriptor.toProtocol()).setTotalBytes(this.bytes).setTotalRecords(this.records).build();
    }
}

