/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.example.integration;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.JsonFileReader;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Validator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IntegrationTestClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrationTestClient.class);
    private final Options options = new Options();

    private IntegrationTestClient() {
        this.options.addOption("j", "json", true, "json file");
        this.options.addOption("host", true, "The host to connect to.");
        this.options.addOption("port", true, "The port to connect to.");
    }

    public static void main(String[] args) {
        try {
            new IntegrationTestClient().run(args);
        }
        catch (ParseException e) {
            IntegrationTestClient.fatalError("Invalid parameters", e);
        }
        catch (IOException e) {
            IntegrationTestClient.fatalError("Error accessing files", e);
        }
    }

    private static void fatalError(String message, Throwable e) {
        System.err.println(message);
        System.err.println(e.getMessage());
        LOGGER.error(message, e);
        System.exit(1);
    }

    private void run(String[] args) throws ParseException, IOException {
        VectorSchemaRoot jsonRoot;
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(this.options, args, false);
        String host = cmd.getOptionValue("host", "localhost");
        int port = Integer.parseInt(cmd.getOptionValue("port", "31337"));
        RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
        FlightClient client = new FlightClient((BufferAllocator)allocator, new Location(host, port));
        String inputPath = cmd.getOptionValue("j");
        FlightDescriptor descriptor = FlightDescriptor.path(inputPath);
        try (JsonFileReader reader = new JsonFileReader(new File(inputPath), (BufferAllocator)allocator);
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)reader.start(), (BufferAllocator)allocator);){
            jsonRoot = VectorSchemaRoot.create((Schema)root.getSchema(), (BufferAllocator)allocator);
            VectorUnloader unloader = new VectorUnloader(root);
            VectorLoader jsonLoader = new VectorLoader(jsonRoot);
            FlightClient.ClientStreamListener stream = client.startPut(descriptor, root);
            while (reader.read(root)) {
                stream.putNext();
                jsonLoader.load(unloader.getRecordBatch());
                root.clear();
            }
            stream.completed();
            stream.getResult();
        }
        FlightInfo info = client.getInfo(descriptor);
        List<FlightEndpoint> endpoints = info.getEndpoints();
        if (endpoints.isEmpty()) {
            throw new RuntimeException("No endpoints returned from Flight server.");
        }
        for (FlightEndpoint endpoint : info.getEndpoints()) {
            List<Location> locations = endpoint.getLocations();
            if (locations.size() == 0) {
                locations = Collections.singletonList(new Location(host, port));
            }
            for (Location location : locations) {
                VectorSchemaRoot downloadedRoot;
                System.out.println("Verifying location " + location.getHost() + ":" + location.getPort());
                FlightClient readClient = new FlightClient((BufferAllocator)allocator, location);
                FlightStream stream = readClient.getStream(endpoint.getTicket());
                try (VectorSchemaRoot root = stream.getRoot();){
                    downloadedRoot = VectorSchemaRoot.create((Schema)root.getSchema(), (BufferAllocator)allocator);
                    VectorLoader loader = new VectorLoader(downloadedRoot);
                    VectorUnloader unloader = new VectorUnloader(root);
                    while (stream.next()) {
                        loader.load(unloader.getRecordBatch());
                    }
                }
                Validator.compareVectorSchemaRoot((VectorSchemaRoot)jsonRoot, (VectorSchemaRoot)downloadedRoot);
            }
        }
    }
}

