/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.auth;

import com.google.common.base.Throwables;
import com.google.protobuf.ByteString;
import io.grpc.stub.StreamObserver;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.arrow.flight.auth.ClientAuthHandler;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.flight.impl.FlightServiceGrpc;

public class ClientAuthWrapper {
    public static byte[] doClientAuth(ClientAuthHandler authHandler, FlightServiceGrpc.FlightServiceStub stub) {
        AuthObserver observer = new AuthObserver();
        observer.responseObserver = stub.handshake(observer);
        byte[] bytes = authHandler.authenticate(observer.sender, observer.iter);
        observer.responseObserver.onCompleted();
        return bytes;
    }

    private static class AuthObserver
    implements StreamObserver<Flight.HandshakeResponse> {
        private volatile StreamObserver<Flight.HandshakeRequest> responseObserver;
        private final LinkedBlockingQueue<byte[]> messages = new LinkedBlockingQueue();
        private final AuthSender sender = new AuthSender();
        private volatile boolean completed = false;
        private Throwable ex = null;
        private Iterator<byte[]> iter = new Iterator<byte[]>(){

            @Override
            public byte[] next() {
                while (!(ex != null || completed && messages.isEmpty())) {
                    byte[] bytes = (byte[])messages.poll();
                    if (bytes == null) continue;
                    return bytes;
                }
                if (ex != null) {
                    throw Throwables.propagate((Throwable)ex);
                }
                throw new IllegalStateException("You attempted to retrieve messages after there were none.");
            }

            @Override
            public boolean hasNext() {
                return !messages.isEmpty();
            }
        };

        public void onNext(Flight.HandshakeResponse value) {
            ByteString payload = value.getPayload();
            if (payload != null) {
                this.messages.add(payload.toByteArray());
            }
        }

        public void onError(Throwable t) {
            this.ex = t;
        }

        public void onCompleted() {
            this.completed = true;
        }

        private class AuthSender
        implements ClientAuthHandler.ClientAuthSender {
            private AuthSender() {
            }

            @Override
            public void send(byte[] payload) {
                AuthObserver.this.responseObserver.onNext((Object)Flight.HandshakeRequest.newBuilder().setPayload(ByteString.copyFrom((byte[])payload)).build());
            }

            @Override
            public void onError(String message, Throwable cause) {
                AuthObserver.this.responseObserver.onError(cause);
            }
        }
    }
}

