/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.auth;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Iterator;
import org.apache.arrow.flight.auth.ServerAuthHandler;
import org.apache.arrow.flight.impl.Flight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicServerAuthHandler
implements ServerAuthHandler {
    private static final Logger logger = LoggerFactory.getLogger(BasicServerAuthHandler.class);
    private final BasicAuthValidator authValidator;

    public BasicServerAuthHandler(BasicAuthValidator authValidator) {
        this.authValidator = authValidator;
    }

    @Override
    public boolean authenticate(ServerAuthHandler.ServerAuthSender outgoing, Iterator<byte[]> incoming) {
        byte[] bytes = incoming.next();
        try {
            Flight.BasicAuth auth = Flight.BasicAuth.parseFrom(bytes);
            byte[] token = this.authValidator.getToken(auth.getUsername(), auth.getPassword());
            outgoing.send(token);
            return true;
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug("Failure parsing auth message.", (Throwable)e);
        }
        catch (Exception e) {
            logger.debug("Unknown error during authorization.", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean isValid(byte[] token) {
        return this.authValidator.isValid(token);
    }

    public static interface BasicAuthValidator {
        public byte[] getToken(String var1, String var2) throws Exception;

        public boolean isValid(byte[] var1);
    }
}

