/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.dataset.jni;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.arrow.dataset.jni.JniWrapper;
import org.apache.arrow.dataset.jni.NativeContext;
import org.apache.arrow.dataset.jni.NativeInstanceReleasedException;
import org.apache.arrow.dataset.jni.NativeRecordBatchHandle;
import org.apache.arrow.dataset.jni.NativeScanTask;
import org.apache.arrow.dataset.scanner.ScanTask;
import org.apache.arrow.dataset.scanner.Scanner;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.BufferLedger;
import org.apache.arrow.memory.NativeUnderlyingMemory;
import org.apache.arrow.memory.ReferenceManager;
import org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.SchemaUtility;

public class NativeScanner
implements Scanner {
    private final AtomicBoolean executed = new AtomicBoolean(false);
    private final NativeContext context;
    private final long scannerId;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.lock.writeLock();
    private final Lock readLock = this.lock.readLock();
    private boolean closed = false;

    public NativeScanner(NativeContext context, long scannerId) {
        this.context = context;
        this.scannerId = scannerId;
    }

    ScanTask.BatchIterator execute() {
        if (this.closed) {
            throw new NativeInstanceReleasedException();
        }
        if (!this.executed.compareAndSet(false, true)) {
            throw new UnsupportedOperationException("NativeScanner cannot be executed more than once. Consider creating new scanner instead");
        }
        return new ScanTask.BatchIterator(){
            private ArrowRecordBatch peek = null;

            @Override
            public void close() {
                NativeScanner.this.close();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                NativeRecordBatchHandle handle;
                if (this.peek != null) {
                    return true;
                }
                NativeScanner.this.readLock.lock();
                try {
                    if (NativeScanner.this.closed) {
                        throw new NativeInstanceReleasedException();
                    }
                    handle = JniWrapper.get().nextRecordBatch(NativeScanner.this.scannerId);
                }
                finally {
                    NativeScanner.this.readLock.unlock();
                }
                if (handle == null) {
                    return false;
                }
                ArrayList<ArrowBuf> buffers = new ArrayList<ArrowBuf>();
                for (NativeRecordBatchHandle.Buffer buffer2 : handle.getBuffers()) {
                    BufferAllocator allocator = NativeScanner.this.context.getAllocator();
                    int size = LargeMemoryUtil.checkedCastToInt((long)buffer2.size);
                    NativeUnderlyingMemory am = NativeUnderlyingMemory.create(allocator, size, buffer2.nativeInstanceId, buffer2.memoryAddress);
                    BufferLedger ledger = am.associate(allocator);
                    ArrowBuf buf = new ArrowBuf((ReferenceManager)ledger, null, (long)size, buffer2.memoryAddress);
                    buffers.add(buf);
                }
                try {
                    int numRows = LargeMemoryUtil.checkedCastToInt((long)handle.getNumRows());
                    this.peek = new ArrowRecordBatch(numRows, handle.getFields().stream().map(field -> new ArrowFieldNode(field.length, field.nullCount)).collect(Collectors.toList()), buffers);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    buffers.forEach(buffer -> buffer.getReferenceManager().release());
                }
            }

            @Override
            public ArrowRecordBatch next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    ArrowRecordBatch arrowRecordBatch = this.peek;
                    return arrowRecordBatch;
                }
                finally {
                    this.peek = null;
                }
            }
        };
    }

    public Iterable<? extends NativeScanTask> scan() {
        if (this.closed) {
            throw new NativeInstanceReleasedException();
        }
        return Collections.singletonList(new NativeScanTask(this));
    }

    @Override
    public Schema schema() {
        this.readLock.lock();
        try {
            if (this.closed) {
                throw new NativeInstanceReleasedException();
            }
            Schema schema = SchemaUtility.deserialize((byte[])JniWrapper.get().getSchemaFromScanner(this.scannerId), (BufferAllocator)this.context.getAllocator());
            return schema;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void close() {
        this.writeLock.lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            JniWrapper.get().closeScanner(this.scannerId);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

