/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.dataset.jni;

import org.apache.arrow.dataset.jni.JniLoader;
import org.apache.arrow.dataset.jni.ReservationListener;

public class NativeMemoryPool
implements AutoCloseable {
    private final long nativeInstanceId;

    private NativeMemoryPool(long nativeInstanceId) {
        this.nativeInstanceId = nativeInstanceId;
    }

    public static NativeMemoryPool getDefault() {
        return new NativeMemoryPool(NativeMemoryPool.getDefaultMemoryPool());
    }

    public static NativeMemoryPool createListenable(ReservationListener listener) {
        return new NativeMemoryPool(NativeMemoryPool.createListenableMemoryPool(listener));
    }

    public long getNativeInstanceId() {
        return this.nativeInstanceId;
    }

    public long getBytesAllocated() {
        return NativeMemoryPool.bytesAllocated(this.nativeInstanceId);
    }

    @Override
    public void close() throws Exception {
        NativeMemoryPool.releaseMemoryPool(this.nativeInstanceId);
    }

    private static native long getDefaultMemoryPool();

    private static native long createListenableMemoryPool(ReservationListener var0);

    private static native void releaseMemoryPool(long var0);

    private static native long bytesAllocated(long var0);

    static {
        JniLoader.get().ensureLoaded();
    }
}

