/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.dataset.file;

import java.util.Optional;
import org.apache.arrow.dataset.file.FileFormat;
import org.apache.arrow.dataset.file.JniWrapper;
import org.apache.arrow.dataset.jni.NativeDatasetFactory;
import org.apache.arrow.dataset.jni.NativeMemoryPool;
import org.apache.arrow.dataset.scanner.FragmentScanOptions;
import org.apache.arrow.memory.BufferAllocator;

public class FileSystemDatasetFactory
extends NativeDatasetFactory {
    public FileSystemDatasetFactory(BufferAllocator allocator, NativeMemoryPool memoryPool, FileFormat format, String uri) {
        super(allocator, memoryPool, FileSystemDatasetFactory.createNative(format, uri, Optional.empty()));
    }

    public FileSystemDatasetFactory(BufferAllocator allocator, NativeMemoryPool memoryPool, FileFormat format, String uri, Optional<FragmentScanOptions> fragmentScanOptions) {
        super(allocator, memoryPool, FileSystemDatasetFactory.createNative(format, uri, fragmentScanOptions));
    }

    public FileSystemDatasetFactory(BufferAllocator allocator, NativeMemoryPool memoryPool, FileFormat format, String[] uris) {
        super(allocator, memoryPool, FileSystemDatasetFactory.createNative(format, uris, Optional.empty()));
    }

    public FileSystemDatasetFactory(BufferAllocator allocator, NativeMemoryPool memoryPool, FileFormat format, String[] uris, Optional<FragmentScanOptions> fragmentScanOptions) {
        super(allocator, memoryPool, FileSystemDatasetFactory.createNative(format, uris, fragmentScanOptions));
    }

    private static long createNative(FileFormat format, String uri, Optional<FragmentScanOptions> fragmentScanOptions) {
        return JniWrapper.get().makeFileSystemDatasetFactory(uri, format.id(), fragmentScanOptions.map(FragmentScanOptions::serialize).orElse(null));
    }

    private static long createNative(FileFormat format, String[] uris, Optional<FragmentScanOptions> fragmentScanOptions) {
        return JniWrapper.get().makeFileSystemDatasetFactoryWithFiles(uris, format.id(), fragmentScanOptions.map(FragmentScanOptions::serialize).orElse(null));
    }
}

