/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.arrow.c.BaseStruct;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.OwnershipTransferResult;
import org.apache.arrow.memory.ReferenceManager;
import org.apache.arrow.util.Preconditions;

final class CDataReferenceManager
implements ReferenceManager {
    private final AtomicInteger bufRefCnt = new AtomicInteger(0);
    private final BaseStruct struct;

    CDataReferenceManager(BaseStruct struct) {
        this.struct = struct;
    }

    public int getRefCount() {
        return this.bufRefCnt.get();
    }

    public boolean release() {
        return this.release(1);
    }

    void increment() {
        this.bufRefCnt.incrementAndGet();
    }

    public boolean release(int decrement) {
        Preconditions.checkState((decrement >= 1 ? 1 : 0) != 0, (Object)"ref count decrement should be greater than or equal to 1");
        int refCnt = this.bufRefCnt.addAndGet(-decrement);
        Preconditions.checkState((refCnt >= 0 ? 1 : 0) != 0, (Object)"ref count has gone negative");
        if (refCnt == 0) {
            this.struct.release();
            this.struct.close();
        }
        return refCnt == 0;
    }

    public void retain() {
        this.retain(1);
    }

    public void retain(int increment) {
        Preconditions.checkArgument((increment > 0 ? 1 : 0) != 0, (String)"retain(%s) argument is not positive", (int)increment);
        int originalReferenceCount = this.bufRefCnt.getAndAdd(increment);
        Preconditions.checkState((originalReferenceCount > 0 ? 1 : 0) != 0, (Object)"retain called but memory was already released");
    }

    public ArrowBuf retain(ArrowBuf srcBuffer, BufferAllocator targetAllocator) {
        this.retain();
        ArrowBuf targetArrowBuf = this.deriveBuffer(srcBuffer, 0L, srcBuffer.capacity());
        targetArrowBuf.readerIndex(srcBuffer.readerIndex());
        targetArrowBuf.writerIndex(srcBuffer.writerIndex());
        return targetArrowBuf;
    }

    public ArrowBuf deriveBuffer(ArrowBuf sourceBuffer, long index, long length) {
        long derivedBufferAddress = sourceBuffer.memoryAddress() + index;
        return new ArrowBuf((ReferenceManager)this, null, length, derivedBufferAddress);
    }

    public OwnershipTransferResult transferOwnership(ArrowBuf sourceBuffer, BufferAllocator targetAllocator) {
        throw new UnsupportedOperationException();
    }

    public BufferAllocator getAllocator() {
        return null;
    }

    public long getSize() {
        return 0L;
    }

    public long getAccountedSize() {
        return 0L;
    }
}

