/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.arrow.c.BaseStruct;
import org.apache.arrow.c.jni.JniWrapper;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.ReferenceManager;
import org.apache.arrow.memory.util.MemoryUtil;
import org.apache.arrow.util.Preconditions;

public class ArrowArray
implements BaseStruct {
    private static final int SIZE_OF = 80;
    private static final int INDEX_RELEASE_CALLBACK = 64;
    private ArrowBuf data;

    public static ArrowArray wrap(long memoryAddress) {
        return new ArrowArray(new ArrowBuf(ReferenceManager.NO_OP, null, 80L, memoryAddress));
    }

    public static ArrowArray allocateNew(BufferAllocator allocator) {
        ArrowArray array = new ArrowArray(allocator.buffer(80L));
        array.markReleased();
        return array;
    }

    ArrowArray(ArrowBuf data) {
        Preconditions.checkNotNull((Object)data, (Object)"ArrowArray initialized with a null buffer");
        this.data = data;
    }

    public void markReleased() {
        this.directBuffer().putLong(64, 0L);
    }

    @Override
    public long memoryAddress() {
        Preconditions.checkNotNull((Object)this.data, (Object)"ArrowArray is already closed");
        return this.data.memoryAddress();
    }

    @Override
    public void release() {
        long address = this.memoryAddress();
        JniWrapper.get().releaseArray(address);
    }

    @Override
    public void close() {
        if (this.data != null) {
            this.data.close();
            this.data = null;
        }
    }

    private ByteBuffer directBuffer() {
        return MemoryUtil.directBuffer((long)this.memoryAddress(), (int)80).order(ByteOrder.nativeOrder());
    }

    public Snapshot snapshot() {
        ByteBuffer data = this.directBuffer();
        Snapshot snapshot = new Snapshot();
        snapshot.length = data.getLong();
        snapshot.null_count = data.getLong();
        snapshot.offset = data.getLong();
        snapshot.n_buffers = data.getLong();
        snapshot.n_children = data.getLong();
        snapshot.buffers = data.getLong();
        snapshot.children = data.getLong();
        snapshot.dictionary = data.getLong();
        snapshot.release = data.getLong();
        snapshot.private_data = data.getLong();
        return snapshot;
    }

    public void save(Snapshot snapshot) {
        this.directBuffer().putLong(snapshot.length).putLong(snapshot.null_count).putLong(snapshot.offset).putLong(snapshot.n_buffers).putLong(snapshot.n_children).putLong(snapshot.buffers).putLong(snapshot.children).putLong(snapshot.dictionary).putLong(snapshot.release).putLong(snapshot.private_data);
    }

    public static class Snapshot {
        public long length = 0L;
        public long null_count = 0L;
        public long offset = 0L;
        public long n_buffers = 0L;
        public long n_children = 0L;
        public long buffers = 0L;
        public long children = 0L;
        public long dictionary = 0L;
        public long release = 0L;
        public long private_data = 0L;
    }
}

