/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Collections2;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.TypeLayout;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.compression.CompressionCodec;
import org.apache.arrow.vector.compression.CompressionUtil;
import org.apache.arrow.vector.compression.NoCompressionCodec;
import org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;

public class StructVectorLoader {
    private final Schema schema;
    private final CompressionCodec.Factory factory;
    private boolean decompressionNeeded;

    public StructVectorLoader(Schema schema) {
        this(schema, (CompressionCodec.Factory)NoCompressionCodec.Factory.INSTANCE);
    }

    public StructVectorLoader(Schema schema, CompressionCodec.Factory factory) {
        this.schema = schema;
        this.factory = factory;
    }

    public StructVector load(BufferAllocator allocator, ArrowRecordBatch recordBatch) {
        StructVector result = StructVector.empty((String)"", (BufferAllocator)allocator);
        result.initializeChildrenFromFields(this.schema.getFields());
        Iterator<ArrowBuf> buffers = recordBatch.getBuffers().iterator();
        Iterator<ArrowFieldNode> nodes = recordBatch.getNodes().iterator();
        CompressionUtil.CodecType codecType = CompressionUtil.CodecType.fromCompressionType((byte)recordBatch.getBodyCompression().getCodec());
        this.decompressionNeeded = codecType != CompressionUtil.CodecType.NO_COMPRESSION;
        NoCompressionCodec codec = this.decompressionNeeded ? this.factory.createCodec(codecType) : NoCompressionCodec.INSTANCE;
        for (FieldVector fieldVector : result.getChildrenFromFields()) {
            this.loadBuffers(fieldVector, fieldVector.getField(), buffers, nodes, (CompressionCodec)codec);
        }
        result.loadFieldBuffers(new ArrowFieldNode((long)recordBatch.getLength(), 0L), Collections.singletonList(null));
        if (nodes.hasNext() || buffers.hasNext()) {
            throw new IllegalArgumentException("not all nodes and buffers were consumed. nodes: " + Collections2.toList(nodes).toString() + " buffers: " + Collections2.toList(buffers).toString());
        }
        return result;
    }

    private void loadBuffers(FieldVector vector, Field field, Iterator<ArrowBuf> buffers, Iterator<ArrowFieldNode> nodes, CompressionCodec codec) {
        Preconditions.checkArgument((boolean)nodes.hasNext(), (String)"no more field nodes for for field %s and vector %s", (Object)field, (Object)vector);
        ArrowFieldNode fieldNode = nodes.next();
        int bufferLayoutCount = TypeLayout.getTypeBufferCount((ArrowType)field.getType());
        ArrayList<ArrowBuf> ownBuffers = new ArrayList<ArrowBuf>(bufferLayoutCount);
        for (int j = 0; j < bufferLayoutCount; ++j) {
            ArrowBuf nextBuf = buffers.next();
            ArrowBuf bufferToAdd = nextBuf.writerIndex() > 0L ? codec.decompress(vector.getAllocator(), nextBuf) : nextBuf;
            ownBuffers.add(bufferToAdd);
            if (!this.decompressionNeeded) continue;
            nextBuf.getReferenceManager().retain();
        }
        try {
            vector.loadFieldBuffers(fieldNode, ownBuffers);
            if (this.decompressionNeeded) {
                for (ArrowBuf buf : ownBuffers) {
                    buf.close();
                }
            }
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not load buffers for field " + field + ". error message: " + e.getMessage(), e);
        }
        List children = field.getChildren();
        if (children.size() > 0) {
            List childrenFromFields = vector.getChildrenFromFields();
            Preconditions.checkArgument((children.size() == childrenFromFields.size() ? 1 : 0) != 0, (String)"should have as many children as in the schema: found %s expected %s", (int)childrenFromFields.size(), (int)children.size());
            for (int i = 0; i < childrenFromFields.size(); ++i) {
                Field child = (Field)children.get(i);
                FieldVector fieldVector = (FieldVector)childrenFromFields.get(i);
                this.loadBuffers(fieldVector, child, buffers, nodes, codec);
            }
        }
    }
}

