/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.arrow.c.ArrowArray;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.BaseStruct;
import org.apache.arrow.c.jni.CDataJniException;
import org.apache.arrow.c.jni.JniWrapper;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.ReferenceManager;
import org.apache.arrow.memory.util.MemoryUtil;
import org.apache.arrow.util.Preconditions;

public class ArrowArrayStream
implements BaseStruct {
    private static final int SIZE_OF = 40;
    private static final int INDEX_RELEASE_CALLBACK = 24;
    private ArrowBuf data;

    public static ArrowArrayStream wrap(long memoryAddress) {
        return new ArrowArrayStream(new ArrowBuf(ReferenceManager.NO_OP, null, 40L, memoryAddress));
    }

    public static ArrowArrayStream allocateNew(BufferAllocator allocator) {
        ArrowArrayStream array = new ArrowArrayStream(allocator.buffer(40L));
        array.markReleased();
        return array;
    }

    ArrowArrayStream(ArrowBuf data) {
        Preconditions.checkNotNull((Object)data, (Object)"ArrowArrayStream initialized with a null buffer");
        this.data = data;
    }

    public void markReleased() {
        this.directBuffer().putLong(24, 0L);
    }

    @Override
    public long memoryAddress() {
        Preconditions.checkNotNull((Object)this.data, (Object)"ArrowArrayStream is already closed");
        return this.data.memoryAddress();
    }

    @Override
    public void release() {
        long address = this.memoryAddress();
        JniWrapper.get().releaseArrayStream(address);
    }

    public void getSchema(ArrowSchema schema) throws IOException {
        long address = this.memoryAddress();
        try {
            JniWrapper.get().getSchemaArrayStream(address, schema.memoryAddress());
        }
        catch (CDataJniException e) {
            throw new IOException("[errno " + e.getErrno() + "] " + e.getMessage());
        }
    }

    public void getNext(ArrowArray array) throws IOException {
        long address = this.memoryAddress();
        try {
            JniWrapper.get().getNextArrayStream(address, array.memoryAddress());
        }
        catch (CDataJniException e) {
            throw new IOException("[errno " + e.getErrno() + "] " + e.getMessage());
        }
    }

    @Override
    public void close() {
        if (this.data != null) {
            this.data.close();
            this.data = null;
        }
    }

    private ByteBuffer directBuffer() {
        return MemoryUtil.directBuffer((long)this.memoryAddress(), (int)40).order(ByteOrder.nativeOrder());
    }

    public Snapshot snapshot() {
        ByteBuffer data = this.directBuffer();
        Snapshot snapshot = new Snapshot();
        snapshot.get_schema = data.getLong();
        snapshot.get_next = data.getLong();
        snapshot.get_last_error = data.getLong();
        snapshot.release = data.getLong();
        snapshot.private_data = data.getLong();
        return snapshot;
    }

    public void save(Snapshot snapshot) {
        this.directBuffer().putLong(snapshot.get_schema).putLong(snapshot.get_next).putLong(snapshot.get_last_error).putLong(snapshot.release).putLong(snapshot.private_data);
    }

    public static class Snapshot {
        public long get_schema = 0L;
        public long get_next = 0L;
        public long get_last_error = 0L;
        public long release = 0L;
        public long private_data = 0L;
    }
}

