/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.consumers;

import java.io.IOException;
import org.apache.arrow.consumers.BaseAvroConsumer;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.avro.io.Decoder;

public class AvroStructConsumer
extends BaseAvroConsumer<StructVector> {
    private final Consumer[] delegates;

    public AvroStructConsumer(StructVector vector, Consumer[] delegates) {
        super(vector);
        this.delegates = delegates;
    }

    @Override
    public void consume(Decoder decoder) throws IOException {
        this.ensureInnerVectorCapacity(this.currentIndex + 1);
        for (int i = 0; i < this.delegates.length; ++i) {
            this.delegates[i].consume(decoder);
        }
        ((StructVector)this.vector).setIndexDefined(this.currentIndex);
        ++this.currentIndex;
    }

    @Override
    public void close() throws Exception {
        super.close();
        AutoCloseables.close((AutoCloseable[])this.delegates);
    }

    @Override
    public boolean resetValueVector(StructVector vector) {
        for (int i = 0; i < this.delegates.length; ++i) {
            this.delegates[i].resetValueVector((FieldVector)vector.getChildrenFromFields().get(i));
        }
        return super.resetValueVector(vector);
    }

    void ensureInnerVectorCapacity(long targetCapacity) {
        for (FieldVector v : ((StructVector)this.vector).getChildrenFromFields()) {
            while ((long)v.getValueCapacity() < targetCapacity) {
                v.reAlloc();
            }
        }
    }
}

