/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow;

import java.util.HashSet;
import java.util.Set;
import org.apache.arrow.AvroToArrowConfig;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;

public class AvroToArrowConfigBuilder {
    private BufferAllocator allocator;
    private int targetBatchSize;
    private DictionaryProvider.MapDictionaryProvider provider;
    private Set<String> skipFieldNames;

    public AvroToArrowConfigBuilder(BufferAllocator allocator) {
        this.allocator = allocator;
        this.targetBatchSize = 1024;
        this.provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        this.skipFieldNames = new HashSet<String>();
    }

    public AvroToArrowConfigBuilder setTargetBatchSize(int targetBatchSize) {
        this.targetBatchSize = targetBatchSize;
        return this;
    }

    public AvroToArrowConfigBuilder setProvider(DictionaryProvider.MapDictionaryProvider provider) {
        this.provider = provider;
        return this;
    }

    public AvroToArrowConfigBuilder setSkipFieldNames(Set<String> skipFieldNames) {
        this.skipFieldNames = skipFieldNames;
        return this;
    }

    public AvroToArrowConfig build() {
        return new AvroToArrowConfig(this.allocator, this.targetBatchSize, this.provider, this.skipFieldNames);
    }
}

