/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers;

import java.io.IOException;
import java.util.List;
import org.apache.arrow.adapter.avro.producers.Producer;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.avro.io.Encoder;

public class CompositeAvroProducer {
    private final List<Producer<? extends FieldVector>> producers;

    public CompositeAvroProducer(List<Producer<? extends FieldVector>> producers) {
        this.producers = producers;
    }

    public List<Producer<?>> getProducers() {
        return this.producers;
    }

    public void produce(Encoder encoder) throws IOException {
        for (Producer<? extends FieldVector> producer : this.producers) {
            producer.produce(encoder);
        }
    }

    public void resetProducerVectors(VectorSchemaRoot root) {
        int index = 0;
        for (Producer<? extends FieldVector> producer : this.producers) {
            producer.resetValueVector((FieldVector)((FieldVector)root.getFieldVectors().get(index)));
        }
    }
}

