/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers;

import java.io.IOException;
import org.apache.arrow.adapter.avro.producers.BaseAvroProducer;
import org.apache.arrow.adapter.avro.producers.Producer;
import org.apache.arrow.vector.FieldVector;
import org.apache.avro.io.Encoder;

public class AvroNullableProducer<T extends FieldVector>
extends BaseAvroProducer<T> {
    private final Producer<T> delegate;

    public AvroNullableProducer(Producer<T> delegate) {
        super(delegate.getVector());
        this.delegate = delegate;
    }

    @Override
    public void produce(Encoder encoder) throws IOException {
        if (this.vector.isNull(this.currentIndex)) {
            encoder.writeInt(1);
            encoder.writeNull();
            this.delegate.skipNull();
        } else {
            encoder.writeInt(0);
            this.delegate.produce(encoder);
        }
        ++this.currentIndex;
    }

    @Override
    public void skipNull() {
        this.delegate.skipNull();
        ++this.currentIndex;
    }

    @Override
    public void setPosition(int index) {
        if (index < 0 || index > this.vector.getValueCount()) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        this.delegate.setPosition(index);
        super.setPosition(index);
    }

    @Override
    public void resetValueVector(T vector) {
        this.delegate.resetValueVector(vector);
    }

    @Override
    public T getVector() {
        return this.delegate.getVector();
    }
}

