/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers;

import java.io.IOException;
import org.apache.arrow.adapter.avro.producers.BaseAvroProducer;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.avro.io.Encoder;

public class AvroFixedSizeBinaryProducer
extends BaseAvroProducer<BaseFixedWidthVector> {
    private final byte[] reuseBytes;

    public AvroFixedSizeBinaryProducer(FixedSizeBinaryVector vector) {
        super(vector);
        this.reuseBytes = new byte[vector.getTypeWidth()];
    }

    protected AvroFixedSizeBinaryProducer(BaseFixedWidthVector vector) {
        super(vector);
        this.reuseBytes = new byte[vector.getTypeWidth()];
    }

    @Override
    public void produce(Encoder encoder) throws IOException {
        long offset = (long)this.currentIndex * (long)((BaseFixedWidthVector)this.vector).getTypeWidth();
        ((BaseFixedWidthVector)this.vector).getDataBuffer().getBytes(offset, this.reuseBytes);
        encoder.writeFixed(this.reuseBytes);
        ++this.currentIndex;
    }
}

