/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.arrow.adapter.avro.producers.BaseAvroProducer;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.avro.io.Encoder;

public class AvroBytesProducer
extends BaseAvroProducer<VarBinaryVector> {
    public AvroBytesProducer(VarBinaryVector vector) {
        super(vector);
    }

    @Override
    public void produce(Encoder encoder) throws IOException {
        long offset = ((VarBinaryVector)this.vector).getStartOffset(this.currentIndex);
        long endOffset = ((VarBinaryVector)this.vector).getEndOffset(this.currentIndex);
        int length = (int)(endOffset - offset);
        ByteBuffer nioBuffer = ((VarBinaryVector)this.vector).getDataBuffer().nioBuffer(offset, length);
        encoder.writeBytes(nioBuffer);
        ++this.currentIndex;
    }
}

