/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.consumers;

import java.io.IOException;
import org.apache.arrow.adapter.avro.consumers.BaseAvroConsumer;
import org.apache.arrow.adapter.avro.consumers.Consumer;
import org.apache.arrow.vector.FieldVector;
import org.apache.avro.io.Decoder;

public class AvroNullableConsumer<T extends FieldVector>
extends BaseAvroConsumer<T> {
    private final Consumer<T> delegate;
    private final int nullIndex;

    public AvroNullableConsumer(Consumer<T> delegate, int nullIndex) {
        super(delegate.getVector());
        this.delegate = delegate;
        this.nullIndex = nullIndex;
    }

    @Override
    public void consume(Decoder decoder) throws IOException {
        int typeIndex = decoder.readInt();
        if (typeIndex == this.nullIndex) {
            decoder.readNull();
            this.delegate.addNull();
        } else {
            this.delegate.consume(decoder);
        }
        ++this.currentIndex;
    }

    @Override
    public void addNull() {
        this.delegate.addNull();
        ++this.currentIndex;
    }

    @Override
    public void setPosition(int index) {
        if (index < 0 || index > this.vector.getValueCount()) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        this.delegate.setPosition(index);
        super.setPosition(index);
    }

    @Override
    public boolean resetValueVector(T vector) {
        boolean delegateOk = this.delegate.resetValueVector(vector);
        boolean thisOk = super.resetValueVector(vector);
        return thisOk && delegateOk;
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.delegate.close();
    }
}

