/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.consumers;

import java.io.IOException;
import org.apache.arrow.consumers.BaseAvroConsumer;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.avro.io.Decoder;

public class AvroArraysConsumer
extends BaseAvroConsumer<ListVector> {
    private final Consumer delegate;

    public AvroArraysConsumer(ListVector vector, Consumer delegate) {
        super(vector);
        this.delegate = delegate;
    }

    @Override
    public void consume(Decoder decoder) throws IOException {
        ((ListVector)this.vector).startNewValue(this.currentIndex);
        long totalCount = 0L;
        long count = decoder.readArrayStart();
        while (count != 0L) {
            this.ensureInnerVectorCapacity(totalCount += count);
            int element = 0;
            while ((long)element < count) {
                this.delegate.consume(decoder);
                ++element;
            }
            count = decoder.arrayNext();
        }
        ((ListVector)this.vector).endValue(this.currentIndex, (int)totalCount);
        ++this.currentIndex;
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.delegate.close();
    }

    @Override
    public boolean resetValueVector(ListVector vector) {
        this.delegate.resetValueVector(vector.getDataVector());
        return super.resetValueVector(vector);
    }

    void ensureInnerVectorCapacity(long targetCapacity) {
        while ((long)((ListVector)this.vector).getDataVector().getValueCapacity() < targetCapacity) {
            ((ListVector)this.vector).getDataVector().reAlloc();
        }
    }
}

