/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.consumers;

import java.io.IOException;
import org.apache.arrow.consumers.BaseAvroConsumer;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.avro.io.Decoder;

public class AvroMapConsumer
extends BaseAvroConsumer<MapVector> {
    private final Consumer delegate;

    public AvroMapConsumer(MapVector vector, Consumer delegate) {
        super(vector);
        this.delegate = delegate;
    }

    @Override
    public void consume(Decoder decoder) throws IOException {
        ((MapVector)this.vector).startNewValue(this.currentIndex);
        long totalCount = 0L;
        long count = decoder.readMapStart();
        while (count != 0L) {
            totalCount += count;
            int element = 0;
            while ((long)element < count) {
                this.delegate.consume(decoder);
                ++element;
            }
            count = decoder.mapNext();
        }
        ((MapVector)this.vector).endValue(this.currentIndex, (int)totalCount);
        ++this.currentIndex;
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.delegate.close();
    }

    @Override
    public boolean resetValueVector(MapVector vector) {
        this.delegate.resetValueVector(vector.getDataVector());
        return super.resetValueVector(vector);
    }
}

