/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.rank;

import java.util.stream.IntStream;
import org.apache.arrow.algorithm.sort.IndexSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;

public class VectorRank<V extends ValueVector> {
    private VectorValueComparator<V> comparator;
    private IntVector indices;
    private final BufferAllocator allocator;

    public VectorRank(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexAtRank(V vector, VectorValueComparator<V> comparator, int rank) {
        Preconditions.checkArgument((rank >= 0 && rank < vector.getValueCount() ? 1 : 0) != 0);
        try {
            this.indices = new IntVector("index vector", this.allocator);
            this.indices.allocateNew(vector.getValueCount());
            IntStream.range(0, vector.getValueCount()).forEach(i -> this.indices.set(i, i));
            comparator.attachVector(vector);
            this.comparator = comparator;
            int pos = this.getRank(0, vector.getValueCount() - 1, rank);
            int n = this.indices.get(pos);
            return n;
        }
        finally {
            this.indices.close();
        }
    }

    private int getRank(int low, int high, int rank) {
        int mid = IndexSorter.partition(low, high, this.indices, this.comparator);
        if (mid < rank) {
            return this.getRank(mid + 1, high, rank);
        }
        if (mid > rank) {
            return this.getRank(low, mid - 1, rank);
        }
        return mid;
    }
}

