/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.algorithm.sort.IndexSorter;
import org.apache.arrow.algorithm.sort.OutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.util.MemoryUtil;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.IntVector;

public class FixedWidthOutOfPlaceVectorSorter<V extends BaseFixedWidthVector>
implements OutOfPlaceVectorSorter<V> {
    protected IndexSorter<V> indexSorter = new IndexSorter();

    @Override
    public void sortOutOfPlace(V srcVector, V dstVector, VectorValueComparator<V> comparator) {
        if (srcVector instanceof BitVector) {
            throw new IllegalArgumentException("BitVector is not supported with FixedWidthOutOfPlaceVectorSorter.");
        }
        comparator.attachVector(srcVector);
        int valueWidth = comparator.getValueWidth();
        ArrowBuf srcValueBuffer = srcVector.getDataBuffer();
        ArrowBuf dstValidityBuffer = dstVector.getValidityBuffer();
        ArrowBuf dstValueBuffer = dstVector.getDataBuffer();
        Preconditions.checkArgument((dstValidityBuffer.capacity() * 8L >= (long)srcVector.getValueCount() ? 1 : 0) != 0, (String)"Not enough capacity for the validity buffer of the dst vector. Expected capacity %s, actual capacity %s", (int)((srcVector.getValueCount() + 7) / 8), (long)dstValidityBuffer.capacity());
        Preconditions.checkArgument((dstValueBuffer.capacity() >= (long)srcVector.getValueCount() * (long)srcVector.getTypeWidth() ? 1 : 0) != 0, (String)"Not enough capacity for the data buffer of the dst vector. Expected capacity %s, actual capacity %s", (int)(srcVector.getValueCount() * srcVector.getTypeWidth()), (long)dstValueBuffer.capacity());
        try (IntVector sortedIndices = new IntVector("", srcVector.getAllocator());){
            sortedIndices.allocateNew(srcVector.getValueCount());
            sortedIndices.setValueCount(srcVector.getValueCount());
            this.indexSorter.sort(srcVector, sortedIndices, comparator);
            for (int dstIndex = 0; dstIndex < sortedIndices.getValueCount(); ++dstIndex) {
                int srcIndex = sortedIndices.get(dstIndex);
                if (srcVector.isNull(srcIndex)) {
                    BitVectorHelper.unsetBit((ArrowBuf)dstValidityBuffer, (int)dstIndex);
                    continue;
                }
                BitVectorHelper.setBit((ArrowBuf)dstValidityBuffer, (long)dstIndex);
                MemoryUtil.UNSAFE.copyMemory(srcValueBuffer.memoryAddress() + (long)srcIndex * (long)valueWidth, dstValueBuffer.memoryAddress() + (long)dstIndex * (long)valueWidth, valueWidth);
            }
        }
    }
}

