/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.vector.ValueVector;

public abstract class VectorValueComparator<V extends ValueVector> {
    protected V vector1;
    protected V vector2;
    protected int valueWidth;
    private boolean checkNullsOnCompare = true;

    public boolean checkNullsOnCompare() {
        return this.checkNullsOnCompare;
    }

    protected VectorValueComparator() {
    }

    protected VectorValueComparator(int valueWidth) {
        this.valueWidth = valueWidth;
    }

    public int getValueWidth() {
        return this.valueWidth;
    }

    public void attachVector(V vector) {
        this.attachVectors(vector, vector);
    }

    public void attachVectors(V vector1, V vector2) {
        this.vector1 = vector1;
        this.vector2 = vector2;
        boolean v1MayHaveNulls = this.mayHaveNulls(vector1);
        boolean v2MayHaveNulls = this.mayHaveNulls(vector2);
        this.checkNullsOnCompare = v1MayHaveNulls || v2MayHaveNulls;
    }

    private boolean mayHaveNulls(V v) {
        if (v.getValueCount() == 0) {
            return true;
        }
        if (!v.getField().isNullable()) {
            return false;
        }
        return v.getNullCount() > 0;
    }

    public int compare(int index1, int index2) {
        if (this.checkNullsOnCompare) {
            boolean isNull1 = this.vector1.isNull(index1);
            boolean isNull2 = this.vector2.isNull(index2);
            if (isNull1 || isNull2) {
                if (isNull1 && isNull2) {
                    return 0;
                }
                if (isNull1) {
                    return -1;
                }
                return 1;
            }
        }
        return this.compareNotNull(index1, index2);
    }

    public abstract int compareNotNull(int var1, int var2);

    public abstract VectorValueComparator<V> createNew();
}

