/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.dictionary;

import java.util.HashMap;
import org.apache.arrow.algorithm.dictionary.DictionaryBuilder;
import org.apache.arrow.memory.util.ArrowBufPointer;
import org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.apache.arrow.memory.util.hash.SimpleHasher;
import org.apache.arrow.vector.ElementAddressableVector;

public class HashTableBasedDictionaryBuilder<V extends ElementAddressableVector>
implements DictionaryBuilder<V> {
    private final V dictionary;
    private final boolean encodeNull;
    private HashMap<ArrowBufPointer, Integer> hashMap = new HashMap();
    private final ArrowBufHasher hasher;
    private ArrowBufPointer nextPointer;

    public HashTableBasedDictionaryBuilder(V dictionary) {
        this(dictionary, false);
    }

    public HashTableBasedDictionaryBuilder(V dictionary, boolean encodeNull) {
        this(dictionary, encodeNull, (ArrowBufHasher)SimpleHasher.INSTANCE);
    }

    public HashTableBasedDictionaryBuilder(V dictionary, boolean encodeNull, ArrowBufHasher hasher) {
        this.dictionary = dictionary;
        this.encodeNull = encodeNull;
        this.hasher = hasher;
        this.nextPointer = new ArrowBufPointer(hasher);
    }

    @Override
    public V getDictionary() {
        return this.dictionary;
    }

    @Override
    public int addValues(V targetVector) {
        int oldDictSize = this.dictionary.getValueCount();
        for (int i = 0; i < targetVector.getValueCount(); ++i) {
            if (!this.encodeNull && targetVector.isNull(i)) continue;
            this.addValue(targetVector, i);
        }
        return this.dictionary.getValueCount() - oldDictSize;
    }

    @Override
    public int addValue(V targetVector, int targetIndex) {
        targetVector.getDataPointer(targetIndex, this.nextPointer);
        Integer index = this.hashMap.get(this.nextPointer);
        if (index == null) {
            int dictSize = this.dictionary.getValueCount();
            this.dictionary.copyFromSafe(targetIndex, dictSize, targetVector);
            this.dictionary.setValueCount(dictSize + 1);
            this.dictionary.getDataPointer(dictSize, this.nextPointer);
            this.hashMap.put(this.nextPointer, dictSize);
            this.nextPointer = new ArrowBufPointer(this.hasher);
            return dictSize;
        }
        return index;
    }
}

