/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.algorithm.sort.InPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.vector.BaseFixedWidthVector;

public class FixedWidthInPlaceVectorSorter<V extends BaseFixedWidthVector>
implements InPlaceVectorSorter<V> {
    private VectorValueComparator<V> comparator;
    private V vec;
    private V pivotBuffer;

    @Override
    public void sortInPlace(V vec, VectorValueComparator<V> comparator) {
        try {
            this.vec = vec;
            this.comparator = comparator;
            this.pivotBuffer = (BaseFixedWidthVector)vec.getField().createVector(vec.getAllocator());
            this.pivotBuffer.allocateNew(1);
            comparator.attachVectors(vec, this.pivotBuffer);
            this.quickSort(0, vec.getValueCount() - 1);
        }
        finally {
            this.pivotBuffer.close();
        }
    }

    private void quickSort(int low, int high) {
        if (low < high) {
            int mid = this.partition(low, high);
            this.quickSort(low, mid - 1);
            this.quickSort(mid + 1, high);
        }
    }

    private int partition(int low, int high) {
        this.pivotBuffer.copyFrom(low, 0, this.vec);
        while (low < high) {
            while (low < high && this.comparator.compare(high, 0) >= 0) {
                --high;
            }
            this.vec.copyFrom(high, low, this.vec);
            while (low < high && this.comparator.compare(low, 0) <= 0) {
                ++low;
            }
            this.vec.copyFrom(low, high, this.vec);
        }
        this.vec.copyFrom(0, low, this.pivotBuffer);
        return low;
    }
}

