/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.holders.NullableVarCharHolder;

public class DefaultVectorComparators {
    private DefaultVectorComparators() {
    }

    public static class VarCharComparator
    extends VectorValueComparator<VarCharVector> {
        private NullableVarCharHolder holder1 = new NullableVarCharHolder();
        private NullableVarCharHolder holder2 = new NullableVarCharHolder();

        @Override
        public int compareNotNull(int index1, int index2) {
            ((VarCharVector)this.vector1).get(index1, this.holder1);
            ((VarCharVector)this.vector2).get(index2, this.holder2);
            int length1 = this.holder1.end - this.holder1.start;
            int length2 = this.holder2.end - this.holder2.start;
            int minLength = length1 < length2 ? length1 : length2;
            for (int i = 0; i < minLength; ++i) {
                byte b2;
                byte b1 = this.holder1.buffer.getByte(this.holder1.start + i);
                if (b1 == (b2 = this.holder2.buffer.getByte(this.holder2.start + i))) continue;
                return b1 - b2;
            }
            return length1 - length2;
        }
    }

    public static class IntComparator
    extends VectorValueComparator<IntVector> {
        public IntComparator() {
            super(4);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            int value1 = ((IntVector)this.vector1).get(index1);
            int value2 = ((IntVector)this.vector2).get(index2);
            return value1 - value2;
        }
    }
}

