/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.weaving.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.spi.ClassTransformer;
import org.apache.aries.jpa.container.weaving.impl.TransformerRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.weaving.WeavingException;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAWeavingHook
implements WeavingHook,
TransformerRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(JPAWeavingHook.class);
    private final Map<Bundle, LinkedHashSet<ClassTransformer>> registeredTransformers = new HashMap<Bundle, LinkedHashSet<ClassTransformer>>();

    JPAWeavingHook() {
    }

    public void weave(WovenClass wovenClass) {
        BundleWiring wiring = wovenClass.getBundleWiring();
        Bundle bundle = wiring.getBundle();
        ClassLoader cl = wiring.getClassLoader();
        Collection<ClassTransformer> transformersToTry = this.getTransformers(bundle);
        for (ClassTransformer transformer : transformersToTry) {
            if (!JPAWeavingHook.transformClass(wovenClass, cl, transformer)) continue;
            LOGGER.info("Weaving " + wovenClass.getClassName() + " using " + transformer.getClass().getName());
            break;
        }
        Class dClass = wovenClass.getDefinedClass();
        if (transformersToTry.isEmpty() && dClass != null && dClass.getAnnotation(Entity.class) != null) {
            LOGGER.warn("Loading " + wovenClass.getClassName() + " before transformer is present");
        }
    }

    private synchronized Collection<ClassTransformer> getTransformers(Bundle bundle) {
        LinkedHashSet<ClassTransformer> transformers = this.registeredTransformers.get(bundle);
        return transformers != null ? new ArrayList<ClassTransformer>(transformers) : Collections.emptyList();
    }

    private static boolean transformClass(WovenClass wovenClass, ClassLoader cl, ClassTransformer transformer) throws ThreadDeath, OutOfMemoryError {
        try {
            byte[] result = transformer.transform(cl, wovenClass.getClassName(), wovenClass.getDefinedClass(), wovenClass.getProtectionDomain(), wovenClass.getBytes());
            if (result != null) {
                wovenClass.setBytes(result);
                wovenClass.getDynamicImports().add("org.eclipse.persistence.*");
                wovenClass.getDynamicImports().add("org.apache.openjpa.*");
                return true;
            }
        }
        catch (Exception t) {
            Bundle b = wovenClass.getBundleWiring().getBundle();
            String msg = String.format("Weaving failure on class %s in bundle %s/%s using transformer %s", wovenClass.getClassName(), b.getSymbolicName(), b.getVersion(), transformer);
            throw new WeavingException(msg, (Throwable)t);
        }
        return false;
    }

    @Override
    public synchronized void addTransformer(Bundle pBundle, ClassTransformer transformer) {
        LOGGER.info("Adding transformer " + transformer.getClass().getName());
        LinkedHashSet<Object> transformers = this.registeredTransformers.get(pBundle);
        if (transformers == null) {
            transformers = new LinkedHashSet();
            this.registeredTransformers.put(pBundle, transformers);
        }
        transformers.add(transformer);
    }

    @Override
    public synchronized void removeTransformer(Bundle pBundle, ClassTransformer transformer) {
        LinkedHashSet<ClassTransformer> set = this.registeredTransformers.get(pBundle);
        if (set == null || !set.remove(transformer)) {
            throw new IllegalStateException("Transformer " + transformer + " not registered");
        }
        if (set.isEmpty()) {
            this.registeredTransformers.remove(pBundle);
        }
    }
}

